/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.Set;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.geometry.Point2D;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

public class AlignBottomAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.alignBottom";

    public AlignBottomAction(DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(ActionEvent e, DrawingView drawingView) {
        ObservableSet<Figure> figures = drawingView.getSelectedFigures();
        Figure lead = drawingView.getSelectionLead();
        this.alignBottom(drawingView, (Set<Figure>)figures, lead);
    }

    private void alignBottom(DrawingView view, Set<Figure> figures, @Nullable Figure lead) {
        if (figures.size() < 2 || lead == null) {
            return;
        }
        DrawingModel model = view.getModel();
        double yInWorld = lead.getLayoutBoundsInWorld().getMaxY();
        Point2D yPointInWorld = new Point2D(0.0, yInWorld);
        for (Figure f : figures) {
            if (f == lead || !f.isEditable()) continue;
            double desiredY = FXTransforms.transform((Transform)f.getWorldToParent(), (Point2D)yPointInWorld).getY();
            double actualY = f.getLayoutBoundsInParent().getMaxY();
            double dy = desiredY - actualY;
            Translate tx = new Translate(0.0, dy);
            model.transformInParent(f, (Transform)tx);
            model.fireLayoutInvalidated(f);
        }
    }
}

