/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.ArrayList;
import java.util.Collection;
import javafx.event.ActionEvent;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;

public class BringToFrontAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.bringToFront";

    public BringToFrontAction(DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(ActionEvent e, DrawingView drawingView) {
        ArrayList<Figure> figures = new ArrayList<Figure>((Collection<Figure>)drawingView.getSelectedFigures());
        this.bringToFront(drawingView, figures);
    }

    public void bringToFront(DrawingView view, Collection<Figure> figures) {
        DrawingModel model = view.getModel();
        for (Figure child : figures) {
            Figure parent = child.getParent();
            if (parent == null || !parent.isEditable() || !parent.isDecomposable()) continue;
            model.insertChildAt(child, parent, parent.getChildren().size() - 1);
        }
    }
}

