/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Supplier;
import javafx.event.ActionEvent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.collection.iterator.Iterators;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jspecify.annotations.Nullable;

public class GroupAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.group";
    public static final String COMBINE_PATHS_ID = "edit.combinePaths";
    public final @Nullable Supplier<Figure> groupFactory;

    public GroupAction(DrawingEditor editor, Supplier<Figure> groupFactory) {
        this(ID, editor, groupFactory);
    }

    public GroupAction(String id, DrawingEditor editor, @Nullable Supplier<Figure> groupFactory) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, id);
        this.groupFactory = groupFactory;
        if (groupFactory == null) {
            this.addDisabler("groupFactory==null");
        }
    }

    @Override
    protected void onActionPerformed(ActionEvent e, DrawingView drawingView) {
        LinkedList<Figure> figures = new LinkedList<Figure>((Collection<Figure>)drawingView.getSelectedFigures());
        GroupAction.group(drawingView, figures, this.groupFactory);
    }

    public static void group(DrawingView view, Collection<Figure> figures, Supplier<Figure> groupFactory) {
        Drawing drawing = view.getDrawing();
        if (drawing == null) {
            return;
        }
        if (figures.isEmpty()) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Empty selection can not be grouped", new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            return;
        }
        Figure first = figures.iterator().next();
        for (Figure child : figures) {
            Alert alert;
            if (child instanceof Layer) {
                alert = new Alert(Alert.AlertType.INFORMATION, "Layers can not be grouped", new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.showAndWait();
                return;
            }
            if (child.getDrawing() != drawing) {
                alert = new Alert(Alert.AlertType.INFORMATION, " Only figures in primary drawing can be grouped", new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.showAndWait();
                return;
            }
            Figure parent = child.getParent();
            if (parent == null || parent.isEditable() && parent.isDecomposable()) continue;
            Alert alert2 = new Alert(Alert.AlertType.INFORMATION, "Only figures in editable and decomposable parents can be grouped", new ButtonType[0]);
            alert2.getDialogPane().setMaxWidth(640.0);
            alert2.showAndWait();
            return;
        }
        Figure parent = first.getParent();
        DrawingModel model = view.getModel();
        Figure group = groupFactory.get();
        model.addChildTo(group, parent);
        for (Figure child : Iterators.toList((Iterable)drawing.breadthFirstIterable())) {
            if (!figures.contains(child)) continue;
            model.addChildTo(child, group);
        }
        view.getSelectedFigures().clear();
        view.getSelectedFigures().add((Object)group);
    }
}

