/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.ArrayList;
import java.util.Collection;
import javafx.event.ActionEvent;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class SelectChildrenAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.selectChildren";

    public SelectChildrenAction(DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        this.set((MapAccessor)Action.ID_KEY, ID);
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(ActionEvent e, DrawingView dview) {
        ArrayList<Figure> figures = new ArrayList<Figure>((Collection<Figure>)dview.getSelectedFigures());
        SelectChildrenAction.selectChildren(dview, figures);
    }

    public static void selectChildren(DrawingView view, Collection<Figure> figures) {
        ArrayList<Figure> selectedChildren = new ArrayList<Figure>();
        for (Figure f : figures) {
            selectedChildren.addAll((Collection<Figure>)f.getChildren());
        }
        view.getSelectedFigures().clear();
        view.getSelectedFigures().addAll(selectedChildren);
    }
}

