/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.ArrayList;
import java.util.Objects;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;

public class SelectSameAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.selectSame";

    public SelectSameAction(DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        this.set((MapAccessor)Action.ID_KEY, ID);
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(ActionEvent e, DrawingView dview) {
        ObservableSet<Figure> selection = dview.getSelectedFigures();
        SelectSameAction.selectSame(dview, selection.isEmpty() ? null : (Figure)selection.iterator().next());
    }

    public static void selectSame(DrawingView view, @Nullable Figure prototype) {
        if (prototype == null) {
            return;
        }
        String stype = prototype.getTypeSelector();
        ReadOnlySet sclass = prototype.getStyleClasses();
        ArrayList<Figure> selectedSame = new ArrayList<Figure>();
        for (Figure f : view.getDrawing().preorderIterable()) {
            if (!f.isSelectable() || !f.isShowing() || !Objects.equals(f.getTypeSelector(), stype) || !Objects.equals(f.getStyleClasses(), sclass) || f == prototype) continue;
            selectedSame.add(f);
        }
        view.getSelectedFigures().clear();
        view.getSelectedFigures().add((Object)prototype);
        view.getSelectedFigures().addAll(selectedSame);
    }
}

