/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.geom.FXSvgPaths;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class FXPathElementsCssConverter
extends AbstractCssConverter<ImmutableList<PathElement>> {
    public FXPathElementsCssConverter(boolean nullable) {
        super(nullable);
    }

    public ImmutableList<PathElement> parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        tt.requireNextToken(-4, "\u27e8SvgPath\u27e9: String expected.");
        String svgPathString = tt.currentStringNonNull();
        try {
            List pathElements = FXSvgPaths.svgStringToPathElements((String)svgPathString);
            return VectorList.copyOf((Iterable)pathElements);
        }
        catch (ParseException ex) {
            ArrayList<Object> p = new ArrayList<Object>();
            p.add(new MoveTo(0.0, 0.0));
            p.add(new LineTo(10.0, 0.0));
            p.add(new LineTo(10.0, 10.0));
            p.add(new LineTo(0.0, 10.0));
            p.add(new ClosePath());
            return VectorList.copyOf(p);
        }
    }

    protected <TT extends ImmutableList<PathElement>> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        out.accept(new CssToken(-4, FXSvgPaths.pathElementsToDoubleSvgString((Iterable)value.asList())));
    }

    public @Nullable String getHelpText() {
        String buf = "Format of \u27e8SvgPath\u27e9: \" \u27e8moveTo \u27e9\uff5b moveTo\uff5c\u27e8lineTo\u27e9\uff5c\u27e8quadTo\u27e9\uff5c\u27e8cubicTo\u27e9\uff5c\u27e8arcTo\u27e9\uff5c\u27e8closePath\u27e9 \uff5d \"\nFormat of \u27e8moveTo \u27e9: M \u27e8x\u27e9 \u27e8y\u27e9 \uff5cm \u27e8dx\u27e9 \u27e8dy\u27e9 \nFormat of \u27e8lineTo \u27e9: L \u27e8x\u27e9 \u27e8y\u27e9 \uff5cl \u27e8dx\u27e9 \u27e8dy\u27e9 | H \u27e8x\u27e9 | h \u27e8dx\u27e9 | V \u27e8y\u27e9 | v \u27e8dy\u27e9\nFormat of \u27e8quadTo \u27e9: Q \u27e8x\u27e9 \u27e8y\u27e9  \u27e8x1\u27e9 \u27e8y1\u27e9 \uff5cq \u27e8dx\u27e9 \u27e8dy\u27e9  \u27e8x1\u27e9 \u27e8y1\u27e9 \uff5cT \u27e8x\u27e9 \u27e8y\u27e9 \uff5ct \u27e8dx\u27e9 \u27e8dy\u27e9\nFormat of \u27e8cubicTo \u27e9: C \u27e8x\u27e9 \u27e8y\u27e9  \u27e8x1\u27e9 \u27e8y1\u27e9  \u27e8x2\u27e9 \u27e8y2\u27e9 \uff5cc \u27e8dx\u27e9 \u27e8dy\u27e9  \u27e8dx1\u27e9 \u27e8dy1\u27e9  \u27e8dx2\u27e9 \u27e8dy2\u27e9\uff5c S \u27e8x\u27e9 \u27e8y\u27e9  \u27e8x1\u27e9 \u27e8y1\u27e9 \uff5cs \u27e8dx\u27e9 \u27e8dy\u27e9  \u27e8dx1\u27e9 \u27e8dy1\u27e9\nFormat of \u27e8arcTo \u27e9: A \u27e8x\u27e9 \u27e8y\u27e9 \u27e8r1\u27e9 \u27e8r2\u27e9 \u27e8angle\u27e9 \u27e8larrgeArcFlag\u27e9 \u27e8sweepFlag\u27e9 \uff5ca \u27e8dx\u27e9 \u27e8dy\u27e9 \u27e8r1\u27e9 \u27e8r2\u27e9 \u27e8angle\u27e9 \u27e8larrgeArcFlag\u27e9 \u27e8sweepFlag\u27e9 \nFormat of \u27e8closePath \u27e9: Z \uff5cz ";
        return buf;
    }

    public @Nullable ImmutableList<PathElement> getDefaultValue() {
        return this.isNullable() ? null : VectorList.of();
    }
}

