/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.geometry.Insets;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class InsetsConverter
extends AbstractCssConverter<Insets> {
    public InsetsConverter(boolean nullable) {
        super(nullable);
    }

    public Insets parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        ArrayList<Number> list = new ArrayList<Number>(4);
        block9: for (int i = 0; i < 4; ++i) {
            switch (tt.next()) {
                case -9: {
                    list.add(tt.currentNumberNonNull());
                    continue block9;
                }
                case 44: {
                    continue block9;
                }
                default: {
                    tt.pushBack();
                }
            }
        }
        switch (list.size()) {
            case 1: {
                double trbl = ((Number)list.getFirst()).doubleValue();
                return new Insets(trbl);
            }
            case 2: {
                double tb = ((Number)list.get(0)).doubleValue();
                double rl = ((Number)list.get(1)).doubleValue();
                return new Insets(tb, rl, tb, rl);
            }
            case 4: {
                double t = ((Number)list.get(0)).doubleValue();
                double r = ((Number)list.get(1)).doubleValue();
                double b = ((Number)list.get(2)).doubleValue();
                double l = ((Number)list.get(3)).doubleValue();
                return new Insets(t, r, b, l);
            }
        }
        throw new ParseException("\u27e8Insets\u27e9: \u27e8top-right-bottom-left\u27e9 \uff5c \u27e8top-bottom\u27e9,\u27e8left-right\u27e9 \uff5c \u27e8top\u27e9,\u27e8right\u27e9,\u27e8bottom\u27e9,\u27e8left\u27e9 expected.", tt.getStartPosition());
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Insets\u27e9: \u27e8top-right-bottom-left\u27e9 \uff5c \u27e8top-bottom\u27e9 \u27e8left-right\u27e9 \uff5c \u27e8top\u27e9 \u27e8right\u27e9 \u27e8bottom\u27e9 \u27e8left\u27e9";
    }

    protected <TT extends Insets> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        if (value.getRight() == value.getLeft() && value.getTop() == value.getBottom()) {
            if (value.getTop() == value.getLeft()) {
                out.accept(new CssToken(-9, (Number)value.getTop()));
            } else {
                out.accept(new CssToken(-9, (Number)value.getTop()));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-9, (Number)value.getRight()));
            }
            return;
        }
        out.accept(new CssToken(-9, (Number)value.getTop()));
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-9, (Number)value.getRight()));
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-9, (Number)value.getBottom()));
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-9, (Number)value.getLeft()));
    }
}

