/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssInsets;
import org.jspecify.annotations.Nullable;

public class InsetsCssConverter
extends AbstractCssConverter<CssInsets> {
    public InsetsCssConverter(boolean nullable) {
        super(nullable);
    }

    public CssInsets parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        ArrayList<CssSize> list = new ArrayList<CssSize>(4);
        block9: for (int i = 0; i < 4; ++i) {
            switch (tt.next()) {
                case -11: 
                case -9: {
                    tt.pushBack();
                    list.add(SizeCssConverter.parseSize((CssTokenizer)tt, (String)("" + i)));
                    continue block9;
                }
                case 44: {
                    continue block9;
                }
                default: {
                    tt.pushBack();
                }
            }
        }
        switch (list.size()) {
            case 1: {
                CssSize trbl = (CssSize)list.getFirst();
                return new CssInsets(trbl, trbl, trbl, trbl);
            }
            case 2: {
                CssSize tb = (CssSize)list.get(0);
                CssSize rl = (CssSize)list.get(1);
                return new CssInsets(tb, rl, tb, rl);
            }
            case 4: {
                CssSize t = (CssSize)list.get(0);
                CssSize r = (CssSize)list.get(1);
                CssSize b = (CssSize)list.get(2);
                CssSize l = (CssSize)list.get(3);
                return new CssInsets(t, r, b, l);
            }
        }
        throw new ParseException("\u27e8DimensionInsets\u27e9: \u27e8top-right-bottom-left\u27e9 \uff5c \u27e8top-bottom\u27e9,\u27e8left-right\u27e9 \uff5c \u27e8top\u27e9,\u27e8right\u27e9,\u27e8bottom\u27e9,\u27e8left\u27e9 expected.", tt.getStartPosition());
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8DimensionInsets\u27e9: \u27e8top-right-bottom-left\u27e9 \uff5c \u27e8top-bottom\u27e9 \u27e8left-right\u27e9 \uff5c \u27e8top\u27e9 \u27e8right\u27e9 \u27e8bottom\u27e9 \u27e8left\u27e9";
    }

    protected <TT extends CssInsets> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        CssSize top = value.getTop();
        CssSize right = value.getRight();
        CssSize bottom = value.getBottom();
        CssSize left = value.getLeft();
        if (right == left && top == bottom) {
            if (top == left) {
                out.accept(new CssToken(-11, (Number)top.getValue(), top.getUnits()));
            } else {
                out.accept(new CssToken(-11, (Number)top.getValue(), top.getUnits()));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-11, (Number)right.getValue(), right.getUnits()));
            }
            return;
        }
        out.accept(new CssToken(-11, (Number)top.getValue(), top.getUnits()));
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-11, (Number)right.getValue(), right.getUnits()));
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-11, (Number)bottom.getValue(), bottom.getUnits()));
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-11, (Number)left.getValue(), left.getUnits()));
    }
}

