/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.text.ParseException;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.draw.css.converter.PaintableCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssLinearGradient;
import org.jhotdraw8.draw.css.value.CssRadialGradient;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jspecify.annotations.Nullable;

public class PaintCssConverter
extends AbstractCssConverter<Paint> {
    protected static final PaintableCssConverter paintableConverter = new PaintableCssConverter(false);

    public PaintCssConverter() {
        this(false);
    }

    public PaintCssConverter(boolean nullable) {
        super(nullable);
    }

    public Paint parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        Paintable p = paintableConverter.parseNonNull(tt, idResolver);
        if (p.getPaint() == null) {
            throw new ParseException("paint", 0);
        }
        return p.getPaint();
    }

    public @Nullable String getHelpText() {
        return paintableConverter.getHelpText();
    }

    protected <TT extends Paint> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) throws IOException {
        TT TT = value;
        Objects.requireNonNull(TT);
        TT TT2 = TT;
        int n = 0;
        Paintable p = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Color.class, LinearGradient.class, RadialGradient.class}, TT2, n)) {
            case 0 -> {
                Color color = (Color)TT2;
                yield new CssColor(color);
            }
            case 1 -> {
                LinearGradient linearGradient = (LinearGradient)TT2;
                yield new CssLinearGradient(linearGradient);
            }
            case 2 -> {
                RadialGradient radialGradient = (RadialGradient)TT2;
                yield new CssRadialGradient(radialGradient);
            }
            default -> throw new UnsupportedOperationException("unsupported value:" + String.valueOf(value));
        };
        paintableConverter.produceTokensNonNull(p, idSupplier, out);
    }
}

