/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import javafx.geometry.Point2D;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class Point2DConverter
extends AbstractCssConverter<Point2D> {
    private final boolean withSpace;
    private final boolean withComma;

    public Point2DConverter(boolean nullable) {
        this(nullable, true);
    }

    public Point2DConverter(boolean nullable, boolean withSpace) {
        super(nullable);
        this.withSpace = withSpace;
        this.withComma = !withSpace;
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Point2D\u27e9: \u27e8x\u27e9, \u27e8y\u27e9";
    }

    public Point2D parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        tt.requireNextToken(-9, " \u27e8Point2D\u27e9: \u27e8x\u27e9 expected.");
        double x = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8Point2D\u27e9: \u27e8y\u27e9 expected.");
        double y = tt.currentNumberNonNull().doubleValue();
        return new Point2D(x, y);
    }

    protected <TT extends Point2D> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        out.accept(new CssToken(-9, (Number)value.getX()));
        this.produceDelimiter(out);
        out.accept(new CssToken(-9, (Number)value.getY()));
    }

    private void produceDelimiter(Consumer<CssToken> out) {
        if (this.withComma) {
            out.accept(new CssToken(44));
        }
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
    }
}

