/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import javafx.geometry.Point3D;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class Point3DConverter
extends AbstractCssConverter<Point3D> {
    private final boolean withComma = false;
    private final boolean withSpace;

    public Point3DConverter(boolean nullable) {
        this(nullable, true);
    }

    public Point3DConverter(boolean nullable, boolean withSpace) {
        super(nullable);
        this.withSpace = withSpace;
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Point3D\u27e9: \u27e8x\u27e9 \u27e8y\u27e9 \uff5c \u27e8x\u27e9 \u27e8y\u27e9 \u27e8z\u27e9";
    }

    public Point3D parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        double z;
        tt.requireNextToken(-9, " \u27e8Point3D\u27e9: \u27e8x\u27e9 expected.");
        double x = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8Point3D\u27e9: \u27e8y\u27e9 expected.");
        double y = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        if (tt.next() == -9) {
            tt.pushBack();
            z = tt.currentNumberNonNull().doubleValue();
        } else {
            z = 0.0;
        }
        return new Point3D(x, y, z);
    }

    private void produceDelimiter(Consumer<CssToken> out) {
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
    }

    protected <TT extends Point3D> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        out.accept(new CssToken(-9, (Number)value.getX()));
        this.produceDelimiter(out);
        out.accept(new CssToken(-9, (Number)value.getY()));
        double z = value.getZ();
        if (z != 0.0) {
            this.produceDelimiter(out);
            out.accept(new CssToken(-9, (Number)z));
        }
    }
}

