/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import javafx.geometry.Rectangle2D;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class Rectangle2DConverter
extends AbstractCssConverter<Rectangle2D> {
    private final boolean withSpace;
    private final boolean withComma;

    public Rectangle2DConverter(boolean nullable) {
        this(nullable, true, false);
    }

    public Rectangle2DConverter(boolean nullable, boolean withSpace, boolean withComma) {
        super(nullable);
        this.withSpace = withSpace || !withComma;
        this.withComma = withComma;
    }

    public Rectangle2D parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        tt.requireNextToken(-9, " \u27e8Rectangle2D\u27e9: \u27e8x\u27e9 expected.");
        double x = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8Rectangle2D\u27e9: \u27e8y\u27e9 expected.");
        double y = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8Rectangle2D\u27e9: \u27e8width\u27e9 expected.");
        double width = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8Rectangle2D\u27e9: \u27e8height\u27e9 expected.");
        double height = tt.currentNumberNonNull().doubleValue();
        return new Rectangle2D(x, y, width, height);
    }

    protected <TT extends Rectangle2D> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        out.accept(new CssToken(-9, (Number)value.getMinX()));
        this.produceDelimiter(out);
        out.accept(new CssToken(-9, (Number)value.getMinY()));
        this.produceDelimiter(out);
        out.accept(new CssToken(-9, (Number)value.getWidth()));
        this.produceDelimiter(out);
        out.accept(new CssToken(-9, (Number)value.getHeight()));
    }

    private void produceDelimiter(Consumer<CssToken> out) {
        if (this.withComma) {
            out.accept(new CssToken(44));
        }
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Rectangle2D\u27e9: \u27e8x\u27e9 \u27e8y\u27e9 \u27e8width\u27e9 \u27e8height\u27e9";
    }
}

