/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jspecify.annotations.Nullable;

public class Rectangle2DCssConverter
extends AbstractCssConverter<CssRectangle2D> {
    private final boolean withSpace;
    private final boolean withComma;

    public Rectangle2DCssConverter(boolean nullable) {
        this(nullable, true, false);
    }

    public Rectangle2DCssConverter(boolean nullable, boolean withSpace, boolean withComma) {
        super(nullable);
        this.withSpace = withSpace || !withComma;
        this.withComma = withComma;
    }

    public CssRectangle2D parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        CssSize x = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"x");
        tt.skipIfPresent(44);
        CssSize y = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"y");
        tt.skipIfPresent(44);
        CssSize width = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"width");
        tt.skipIfPresent(44);
        CssSize height = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"height");
        return new CssRectangle2D(x, y, width, height);
    }

    protected <TT extends CssRectangle2D> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        CssSize x = value.getMinX();
        CssSize y = value.getMinY();
        CssSize width = value.getWidth();
        CssSize height = value.getHeight();
        out.accept(new CssToken(-11, (Number)x.getValue(), x.getUnits()));
        this.produceDelimiter(out);
        out.accept(new CssToken(-11, (Number)y.getValue(), y.getUnits()));
        this.produceDelimiter(out);
        out.accept(new CssToken(-11, (Number)width.getValue(), width.getUnits()));
        this.produceDelimiter(out);
        out.accept(new CssToken(-11, (Number)height.getValue(), height.getUnits()));
    }

    private void produceDelimiter(Consumer<CssToken> out) {
        if (this.withComma) {
            out.accept(new CssToken(44));
        }
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8CssRectangle2D\u27e9: \u27e8x\u27e9 \u27e8y\u27e9 \u27e8width\u27e9 \u27e8height\u27e9";
    }
}

