/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import javafx.geometry.Point3D;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class Scale3DCssConverter
extends AbstractCssConverter<Point3D> {
    private final boolean withSpace;
    private final boolean withComma = false;

    public Scale3DCssConverter() {
        this(false, true);
    }

    public Scale3DCssConverter(boolean nullable) {
        this(nullable, true);
    }

    public Scale3DCssConverter(boolean nullable, boolean withSpace) {
        super(nullable);
        this.withSpace = withSpace;
    }

    public Point3D parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        double z;
        double y;
        tt.requireNextToken(-9, " \u27e8Scale3D\u27e9: \u27e8x\u27e9 expected.");
        double x = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        if (tt.next() == -9) {
            y = tt.currentNumberNonNull().doubleValue();
        } else {
            y = x;
            tt.pushBack();
        }
        tt.skipIfPresent(44);
        if (tt.next() == -9) {
            z = tt.currentNumberNonNull().doubleValue();
        } else {
            z = 1.0;
            tt.pushBack();
        }
        return new Point3D(x, y, z);
    }

    protected <TT extends Point3D> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        double x = value.getX();
        double y = value.getY();
        double z = value.getZ();
        out.accept(new CssToken(-9, (Number)x));
        if (x != y || z != 1.0) {
            this.produceDelimiter(out);
            out.accept(new CssToken(-9, (Number)y));
        }
        if (z != 1.0) {
            this.produceDelimiter(out);
            out.accept(new CssToken(-9, (Number)z));
        }
    }

    private void produceDelimiter(Consumer<CssToken> out) {
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
    }

    public @Nullable Point3D getDefaultValue() {
        return new Point3D(1.0, 1.0, 1.0);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Scale3D\u27e9: \u27e8s\u27e9 \uff5c \u27e8xs\u27e9 \u27e8ys\u27e9 \uff5c \u27e8xs\u27e9 \u27e8ys\u27e9 \u27e8zs\u27e9";
    }
}

