/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jspecify.annotations.Nullable;

public class SymmetricCssPoint2DCssConverter
extends AbstractCssConverter<CssPoint2D> {
    private final boolean withSpace;
    private final boolean withComma;

    public SymmetricCssPoint2DCssConverter() {
        this(false, true, false);
    }

    public SymmetricCssPoint2DCssConverter(boolean nullable) {
        this(nullable, true, false);
    }

    public SymmetricCssPoint2DCssConverter(boolean nullable, boolean withSpace, boolean withComma) {
        super(nullable);
        this.withSpace = withSpace;
        this.withComma = withComma || !withSpace;
    }

    public CssPoint2D parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        CssSize y;
        CssSize x = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"x");
        if (tt.next() == -1) {
            y = x;
        } else {
            tt.pushBack();
            tt.skipIfPresent(44);
            y = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"y");
        }
        return new CssPoint2D(x, y);
    }

    protected <TT extends CssPoint2D> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        CssSize x = value.getX();
        CssSize y = value.getY();
        out.accept(new CssToken(-11, (Number)x.getValue(), x.getUnits()));
        if (!x.equals((Object)y)) {
            if (this.withComma) {
                out.accept(new CssToken(44));
            }
            if (this.withSpace) {
                out.accept(new CssToken(-16, " "));
            }
            out.accept(new CssToken(-11, (Number)y.getValue(), y.getUnits()));
        }
    }

    public @Nullable CssPoint2D getDefaultValue() {
        return new CssPoint2D(0.0, 0.0);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8SymmetricPoint2D\u27e9: \u27e8xy\u27e9 \uff5c \u27e8x\u27e9 \u27e8y\u27e9";
    }
}

