/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.function;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.jhotdraw8.css.function.AbstractCssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.ListCssTokenizer;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jspecify.annotations.Nullable;

public abstract class AbstractColorCssFunction<T>
extends AbstractCssFunction<T> {
    protected final ColorCssConverter converter = new ColorCssConverter();

    public AbstractColorCssFunction(String name) {
        super(name);
    }

    protected @Nullable CssColor parseColorValue(T element, CssTokenizer tt, CssFunctionProcessor<T> functionProcessor) throws IOException, ParseException {
        CssColor color = null;
        switch (tt.next()) {
            case -18: {
                String name = tt.currentString();
                tt.pushBack();
                ArrayList list = new ArrayList();
                functionProcessor.processToken(element, tt, list::add, new ArrayDeque());
                if (list.isEmpty()) {
                    throw new ParseException(this.getName() + "(): function " + name + "() must return a value.", tt.getStartPosition());
                }
                color = this.parseResolvedColorValue(element, (CssTokenizer)new ListCssTokenizer(list), functionProcessor);
                break;
            }
            default: {
                tt.pushBack();
                color = this.parseResolvedColorValue(element, tt, functionProcessor);
            }
        }
        return color;
    }

    protected @Nullable CssColor parseResolvedColorValue(T element, CssTokenizer tt, CssFunctionProcessor<T> functionProcessor) throws IOException, ParseException {
        return this.converter.parse(tt, null);
    }
}

