/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.function;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.draw.css.function.AbstractColorCssFunction;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jspecify.annotations.Nullable;

public class LadderCssFunction<T>
extends AbstractColorCssFunction<T> {
    public static final String NAME = "ladder";

    public LadderCssFunction() {
        this(NAME);
    }

    public LadderCssFunction(String name) {
        super(name);
    }

    public void process(T element, CssTokenizer tt, SelectorModel<T> model, CssFunctionProcessor<T> functionProcessor, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        tt.requireNextToken(-18, this.getName() + "():  function " + this.getName() + "() expected.");
        if (!this.getName().equals(tt.currentString())) {
            throw tt.createParseException(this.getName() + "():  function " + this.getName() + "() expected.");
        }
        CssColor primaryColor = this.parseColorValue(element, tt, functionProcessor);
        TreeMap<Double, List<CssColor>> ladder = new TreeMap<Double, List<CssColor>>();
        while (tt.next() == 44) {
            CssColor ladderColor = this.parseColorValue(element, tt, functionProcessor);
            CssSize ladderPercentage = this.parsePercentageValue(element, tt, functionProcessor);
            double percentageValue = DefaultUnitConverter.getInstance().convert(ladderPercentage, "");
            ladder.computeIfAbsent(percentageValue, k -> new ArrayList()).add(ladderColor);
        }
        tt.pushBack();
        tt.requireNextToken(41, this.getName() + "():  ')' expected.");
        double brightness = primaryColor == null ? 0.0 : primaryColor.getColor().getBrightness();
        CssColor computedColor = this.interpolate(brightness, ladder);
        this.converter.produceTokens(computedColor, null, out);
    }

    private @Nullable CssColor interpolate(double brightness, TreeMap<Double, List<CssColor>> ladder) {
        Map.Entry<Double, List<CssColor>> entry = ladder.floorEntry(brightness);
        if (entry == null) {
            entry = ladder.firstEntry();
        }
        if (entry == null) {
            return null;
        }
        List<CssColor> list = entry.getValue();
        return brightness <= entry.getKey() ? list.getFirst() : list.getLast();
    }

    protected CssSize parsePercentageValue(T element, CssTokenizer tt, CssFunctionProcessor<T> functionProcessor) throws IOException, ParseException {
        CssSize size = switch (tt.next()) {
            case -9 -> CssSize.of((double)tt.currentNumberNonNull().doubleValue());
            case -10 -> CssSize.of((double)tt.currentNumberNonNull().doubleValue(), (String)"%");
            default -> throw tt.createParseException(this.getName() + "(): percentage value expected.");
        };
        return size;
    }

    public String getHelpText() {
        return this.getName() + "(\u27e8color\u27e9, \u27e8color\u27e9 \u27e8percentage\u27e9, \u27e8color\u27e9 \u27e8percentage\u27e9 ... )\n    The ladder function interpolates between colors. The effect is as if a gradient is created using the stops provided, and then the brightness of the provided <color> is used to index a color value within that gradient. At 0% brightness, the color at the 0.0 end of the gradient is used; at 100% brightness, the color at the 1.0 end of the gradient is used; and at 50% brightness, the color at 0.5, the midway point of the gradient, is used.";
    }
}

