/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Objects;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import org.jhotdraw8.css.value.CssSize;
import org.jspecify.annotations.Nullable;

public class CssDimension2D {
    public static final CssDimension2D ZERO = new CssDimension2D();
    private final CssSize width;
    private final CssSize height;

    public CssDimension2D(CssSize width, CssSize height) {
        this.width = width;
        this.height = height;
    }

    public CssDimension2D(double width, double height, String units) {
        this(CssSize.of((double)width, (String)units), CssSize.of((double)height, (String)units));
    }

    public CssDimension2D() {
        this(CssSize.ZERO, CssSize.ZERO);
    }

    public CssDimension2D(double width, double height) {
        this(width, height, "");
    }

    public CssDimension2D(Point2D p) {
        this(p.getX(), p.getY());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssDimension2D other = (CssDimension2D)obj;
        if (!Objects.equals(this.width, other.width)) {
            return false;
        }
        return Objects.equals(this.height, other.height);
    }

    public CssSize getWidth() {
        return this.width;
    }

    public CssSize getHeight() {
        return this.height;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.width);
        hash = 89 * hash + Objects.hashCode(this.height);
        return hash;
    }

    public String toString() {
        return "CssPoint2D{" + String.valueOf(this.width) + ", " + String.valueOf(this.height) + "}";
    }

    public Dimension2D getConvertedValue() {
        return new Dimension2D(this.width.getConvertedValue(), this.height.getConvertedValue());
    }

    public CssDimension2D subtract(CssDimension2D that) {
        return new CssDimension2D(this.width.subtract(that.width), this.height.subtract(that.height));
    }

    public CssDimension2D add(CssDimension2D that) {
        return new CssDimension2D(this.width.add(that.width), this.height.add(that.height));
    }
}

