/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.jhotdraw8.css.value.CssSize;
import org.jspecify.annotations.Nullable;

public class CssFont {
    private final String family;
    private final @Nullable FontWeight weight;
    private final @Nullable FontPosture posture;
    private final CssSize size;
    private final Font font;
    private static final Map<String, CssFont> cachedFonts = new ConcurrentHashMap<String, CssFont>();

    public CssFont(String family, @Nullable FontWeight weight, @Nullable FontPosture posture, CssSize size) {
        this.family = family;
        this.weight = weight;
        this.posture = posture;
        this.size = size;
        this.font = weight == FontWeight.NORMAL || posture == FontPosture.REGULAR || weight == null || posture == null ? new Font(family, size.getConvertedValue()) : Font.font((String)family, (FontWeight)weight, (FontPosture)posture, (double)size.getConvertedValue());
    }

    public String getFamily() {
        return this.family;
    }

    public @Nullable FontWeight getWeight() {
        return this.weight;
    }

    public @Nullable FontPosture getPosture() {
        return this.posture;
    }

    public CssSize getSize() {
        return this.size;
    }

    public Font getFont() {
        return this.font;
    }

    public static CssFont font(String family, @Nullable FontWeight weight, @Nullable FontPosture posture, CssSize size) {
        return cachedFonts.computeIfAbsent(family + (weight == null ? "" : weight.name()) + (posture == null ? "" : posture.name()) + Double.doubleToRawLongBits(size.getConvertedValue()), str -> new CssFont(family, weight, posture, size));
    }

    public static CssFont font(String family, @Nullable FontWeight weight, @Nullable FontPosture posture, double size) {
        return CssFont.font(family, weight, posture, CssSize.of((double)size));
    }

    public static CssFont font(String family, double size) {
        return CssFont.font(family, null, null, CssSize.of((double)size));
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.family);
        hash = 97 * hash + Objects.hashCode(this.weight);
        hash = 97 * hash + Objects.hashCode(this.posture);
        hash = 97 * hash + this.size.hashCode();
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssFont other = (CssFont)obj;
        if (!Objects.equals(this.size, other.size)) {
            return false;
        }
        if (!Objects.equals(this.family, other.family)) {
            return false;
        }
        if (this.weight != other.weight) {
            return false;
        }
        return this.posture == other.posture;
    }

    public String toString() {
        return "CssFont{family='" + this.family + "', weight=" + String.valueOf(this.weight) + ", posture=" + String.valueOf(this.posture) + ", size=" + String.valueOf(this.size) + "}";
    }
}

