/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Objects;
import javafx.geometry.Insets;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.css.value.UnitConverter;
import org.jspecify.annotations.Nullable;

public class CssInsets {
    public static final CssInsets ZERO = new CssInsets();
    private final CssSize bottom;
    private final CssSize left;
    private final CssSize right;
    private final CssSize top;

    public CssInsets(CssSize top, CssSize right, CssSize bottom, CssSize left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public CssInsets(double top, double right, double bottom, double left, String units) {
        this(CssSize.of((double)top, (String)units), CssSize.of((double)right, (String)units), CssSize.of((double)bottom, (String)units), CssSize.of((double)left, (String)units));
    }

    public CssInsets() {
        this(CssSize.ZERO, CssSize.ZERO, CssSize.ZERO, CssSize.ZERO);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssInsets other = (CssInsets)obj;
        if (!Objects.equals(this.top, other.top)) {
            return false;
        }
        if (!Objects.equals(this.right, other.right)) {
            return false;
        }
        if (!Objects.equals(this.bottom, other.bottom)) {
            return false;
        }
        return Objects.equals(this.left, other.left);
    }

    public CssSize getBottom() {
        return this.bottom;
    }

    public Insets getConvertedValue(double width, double height) {
        DefaultUnitConverter heightConverter = new DefaultUnitConverter(72.0, height);
        DefaultUnitConverter widthConverter = new DefaultUnitConverter(72.0, width);
        return new Insets(heightConverter.convert(this.top, ""), widthConverter.convert(this.right, ""), heightConverter.convert(this.bottom, ""), widthConverter.convert(this.left, ""));
    }

    public Insets getConvertedValue() {
        return new Insets(this.top.getConvertedValue(), this.right.getConvertedValue(), this.bottom.getConvertedValue(), this.left.getConvertedValue());
    }

    public Insets getConvertedValue(UnitConverter converter, String units) {
        return new Insets(this.top.getConvertedValue(converter, units), this.right.getConvertedValue(converter, units), this.bottom.getConvertedValue(converter, units), this.left.getConvertedValue(converter, units));
    }

    public Insets getConvertedValue(UnitConverter converter) {
        return this.getConvertedValue(converter, "");
    }

    public CssSize getLeft() {
        return this.left;
    }

    public CssSize getRight() {
        return this.right;
    }

    public CssSize getTop() {
        return this.top;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.top);
        hash = 89 * hash + Objects.hashCode(this.right);
        hash = 89 * hash + Objects.hashCode(this.bottom);
        hash = 89 * hash + Objects.hashCode(this.left);
        return hash;
    }

    public String toString() {
        return "CssInsets{" + String.valueOf(this.bottom) + ", " + String.valueOf(this.left) + ", " + String.valueOf(this.right) + ", " + String.valueOf(this.top) + "}";
    }
}

