/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Objects;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import org.jhotdraw8.css.value.CssSize;
import org.jspecify.annotations.Nullable;

public class CssPoint2D {
    public static final CssPoint2D ZERO = new CssPoint2D();
    private final CssSize x;
    private final CssSize y;

    public CssPoint2D(CssSize x, CssSize y) {
        this.x = x;
        this.y = y;
    }

    public CssPoint2D(double x, double y, String units) {
        this(CssSize.of((double)x, (String)units), CssSize.of((double)y, (String)units));
    }

    public CssPoint2D() {
        this(CssSize.ZERO, CssSize.ZERO);
    }

    public CssPoint2D(double x, double y) {
        this(x, y, "");
    }

    public CssPoint2D(Point2D p) {
        this(p.getX(), p.getY());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssPoint2D other = (CssPoint2D)obj;
        if (!Objects.equals(this.x, other.x)) {
            return false;
        }
        return Objects.equals(this.y, other.y);
    }

    public CssSize getX() {
        return this.x;
    }

    public CssSize getY() {
        return this.y;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.x);
        hash = 89 * hash + Objects.hashCode(this.y);
        return hash;
    }

    public String toString() {
        return "CssPoint2D{" + String.valueOf(this.x) + ", " + String.valueOf(this.y) + "}";
    }

    public Point2D getConvertedValue() {
        return new Point2D(this.x.getConvertedValue(), this.y.getConvertedValue());
    }

    public CssPoint2D subtract(CssPoint2D that) {
        return new CssPoint2D(this.x.subtract(that.x), this.y.subtract(that.y));
    }

    public CssPoint2D add(CssPoint2D that) {
        return new CssPoint2D(this.x.add(that.x), this.y.add(that.y));
    }

    public static Point2D getPointInBounds(CssPoint2D p, Bounds bounds) {
        CssSize px = p.getX();
        CssSize py = p.getY();
        double x = switch (px.getUnits()) {
            case "%" -> Math.fma(bounds.getWidth(), px.getValue() / 100.0, bounds.getMinX());
            case "" -> Math.fma(bounds.getWidth(), px.getValue(), bounds.getMinX());
            default -> bounds.getMinX() + px.getConvertedValue();
        };
        double y = switch (py.getUnits()) {
            case "%" -> Math.fma(bounds.getHeight(), py.getValue() / 100.0, bounds.getMinY());
            case "" -> Math.fma(bounds.getHeight(), py.getValue(), bounds.getMinY());
            default -> bounds.getMinY() + py.getConvertedValue();
        };
        return new Point2D(x, y);
    }
}

