/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.jhotdraw8.draw.css.converter.CssStop;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jspecify.annotations.Nullable;

public class CssRadialGradient
implements Paintable {
    private RadialGradient radialGradient;
    private final double focusAngle;
    private final double focusDistance;
    private final double centerX;
    private final double centerY;
    private final double radius;
    private final boolean proportional;
    private final CycleMethod cycleMethod;
    private final CssStop[] cstops;

    public CssRadialGradient() {
        this(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, new CssStop[0]);
    }

    public CssRadialGradient(double focusAngle, double focusDistance, double centerX, double centerY, double radius, boolean proportional, CycleMethod cycleMethod, CssStop ... stops) {
        this.focusAngle = focusAngle;
        this.focusDistance = focusDistance;
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
        this.proportional = proportional;
        this.cycleMethod = cycleMethod;
        this.cstops = stops;
    }

    public CssRadialGradient(RadialGradient radialGradient) {
        this.radialGradient = radialGradient;
        this.centerX = radialGradient.getCenterX();
        this.centerY = radialGradient.getCenterY();
        this.radius = radialGradient.getRadius();
        this.focusAngle = radialGradient.getFocusAngle();
        this.focusDistance = radialGradient.getFocusDistance();
        this.proportional = radialGradient.isProportional();
        this.cycleMethod = radialGradient.getCycleMethod();
        List stopList = radialGradient.getStops();
        this.cstops = new CssStop[stopList.size()];
        for (int i = 0; i < this.cstops.length; ++i) {
            Stop stop = (Stop)stopList.get(i);
            this.cstops[i] = new CssStop(stop.getOffset(), new CssColor(stop.getColor()));
        }
    }

    public RadialGradient getRadialGradient() {
        if (this.radialGradient == null) {
            Stop[] stops = new Stop[this.cstops.length];
            for (int i = 0; i < this.cstops.length; ++i) {
                double offset;
                CssStop cstop = this.cstops[i];
                if (cstop.offset() == null) {
                    double rightOffset;
                    int left;
                    int right = i;
                    for (left = i; left > 0 && this.cstops[left].offset() == null; --left) {
                    }
                    while (right < this.cstops.length - 1 && this.cstops[right].offset() == null) {
                        ++right;
                    }
                    double leftOffset = this.cstops[left].offset() == null ? 0.0 : this.cstops[left].offset();
                    double d = rightOffset = this.cstops[right].offset() == null ? 1.0 : this.cstops[right].offset();
                    if (i == left) {
                        offset = leftOffset;
                    } else if (i == right) {
                        offset = rightOffset;
                    } else {
                        double mix = (double)(i - left) / (double)(right - left);
                        offset = leftOffset * (1.0 - mix) + rightOffset * mix;
                    }
                } else {
                    offset = cstop.offset();
                }
                stops[i] = new Stop(offset, cstop.color().getColor());
            }
            this.radialGradient = new RadialGradient(this.focusAngle, this.focusDistance, this.centerX, this.centerY, this.radius, this.proportional, this.cycleMethod, stops);
        }
        return this.radialGradient;
    }

    @Override
    public Paint getPaint() {
        return this.getRadialGradient();
    }

    public Iterable<CssStop> getStops() {
        return Arrays.asList(this.cstops);
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getFocusAngle() {
        return this.focusAngle;
    }

    public double getFocusDistance() {
        return this.focusDistance;
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssRadialGradient other = (CssRadialGradient)obj;
        if (Double.doubleToLongBits(this.centerX) != Double.doubleToLongBits(other.centerX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.centerY) != Double.doubleToLongBits(other.centerY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.radius) != Double.doubleToLongBits(other.radius)) {
            return false;
        }
        if (Double.doubleToLongBits(this.focusAngle) != Double.doubleToLongBits(other.focusAngle)) {
            return false;
        }
        if (this.proportional != other.proportional) {
            return false;
        }
        if (!Objects.equals(this.radialGradient, other.radialGradient)) {
            return false;
        }
        if (this.cycleMethod != other.cycleMethod) {
            return false;
        }
        return Arrays.deepEquals(this.cstops, other.cstops);
    }

    public String toString() {
        return "CssRadialGradient{focusAngle=" + this.focusAngle + ", focusDistance=" + this.focusDistance + "centerX=" + this.centerX + ", centerY=" + this.centerY + ", radius=" + this.radius + ", proportional=" + this.proportional + ", " + String.valueOf(this.cycleMethod) + ", stops=" + Arrays.toString(this.cstops) + "}";
    }
}

