/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FigurePropertyChangeEvent;
import org.jhotdraw8.fxbase.tree.ChildList;
import org.jhotdraw8.fxbase.tree.TreeNode;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

public abstract class AbstractCompositeFigure
extends AbstractFigure {
    private final ChildList<Figure> children = new ChildList((TreeNode)this);

    @Override
    public ObservableList<Figure> getChildren() {
        return this.children;
    }

    @Override
    public final boolean isAllowsChildren() {
        return true;
    }

    @Override
    public Bounds getLayoutBounds() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Figure child : this.getChildren()) {
            Bounds b = child.getLayoutBoundsInParent();
            minX = Math.min(minX, b.getMinX());
            maxX = Math.max(maxX, b.getMaxX());
            minY = Math.min(minY, b.getMinY());
            maxY = Math.max(maxY, b.getMaxY());
        }
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public Bounds getBoundsInLocal() {
        ObservableList<Figure> children = this.getChildren();
        if (children.isEmpty()) {
            return new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Figure child : children) {
            Bounds b = child.getBoundsInParent();
            minX = Math.min(minX, b.getMinX());
            maxX = Math.max(maxX, b.getMaxX());
            minY = Math.min(minY, b.getMinY());
            maxY = Math.max(maxY, b.getMaxY());
        }
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D(this.getLayoutBounds());
    }

    @Override
    public Bounds getLayoutBoundsInParent() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        Transform t = this.getLocalToParent();
        for (Figure child : this.getChildren()) {
            Bounds b = FXTransforms.transform((Transform)t, (Bounds)child.getLayoutBoundsInParent());
            minX = Math.min(minX, b.getMinX());
            maxX = Math.max(maxX, b.getMaxX());
            minY = Math.min(minY, b.getMinY());
            maxY = Math.max(maxY, b.getMaxY());
        }
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public void firePropertyChangeEvent(FigurePropertyChangeEvent event) {
        Figure source = (Figure)event.getSource();
        if (source.getParent() == this) {
            this.children.fireItemUpdated(this.children.indexOf((Object)source));
        }
        super.firePropertyChangeEvent(event);
    }

    @Override
    public <T> void firePropertyChangeEvent(@Nullable Figure source, Key<T> key, T oldValue, T newValue, boolean wasAdded, boolean wasRemoved) {
        int index;
        if (this.children.hasChangeListeners() && (index = this.children.indexOf((Object)source)) >= 0) {
            this.children.fireItemUpdated(index);
        }
        super.firePropertyChangeEvent(source, key, oldValue, newValue, wasAdded, wasRemoved);
    }
}

