/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.css.StyleOrigin;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.manager.SimpleStylesheetsManager;
import org.jhotdraw8.css.manager.StylesheetsManager;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.model.FigureSelectorModel;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.AbstractCompositeFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public abstract class AbstractDrawing
extends AbstractCompositeFigure
implements Drawing {
    private @Nullable StylesheetsManager<Figure> styleManager = null;

    public AbstractDrawing() {
    }

    public AbstractDrawing(double width, double height) {
        this(CssSize.of((double)width), CssSize.of((double)height));
    }

    public AbstractDrawing(CssSize width, CssSize height) {
        this.set((MapAccessor)WIDTH, width);
        this.set((MapAccessor)HEIGHT, height);
    }

    @Override
    public Node createNode(RenderContext drawingView) {
        Pane g = new Pane();
        g.setManaged(false);
        Group gg = new Group();
        gg.setManaged(false);
        g.getChildren().add((Object)gg);
        return g;
    }

    protected StylesheetsManager<Figure> createStyleManager() {
        return new SimpleStylesheetsManager((SelectorModel)new FigureSelectorModel());
    }

    @Override
    public CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D(CssSize.ZERO, CssSize.ZERO, (CssSize)this.getStyledNonNull(WIDTH), (CssSize)this.getStyledNonNull(HEIGHT));
    }

    @Override
    public Bounds getLayoutBounds() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    @Override
    public @Nullable StylesheetsManager<Figure> getStyleManager() {
        if (this.styleManager == null) {
            this.styleManager = this.createStyleManager();
            this.updateStyleManager();
        }
        return this.styleManager;
    }

    @Override
    public void updateStyleManager() {
        if (this.styleManager != null) {
            this.styleManager.setStylesheets(StyleOrigin.USER_AGENT, (URI)this.get((MapAccessor)DOCUMENT_HOME), this.getList((Key<? extends ImmutableList<URI>>)USER_AGENT_STYLESHEETS));
            this.styleManager.setStylesheets(StyleOrigin.AUTHOR, (URI)this.get((MapAccessor)DOCUMENT_HOME), this.getList((Key<? extends ImmutableList<URI>>)AUTHOR_STYLESHEETS));
            this.styleManager.setStylesheets(StyleOrigin.INLINE, this.getStringList((Key<? extends ImmutableList<String>>)INLINE_STYLESHEETS));
        }
    }

    private List<URI> getList(Key<? extends ImmutableList<URI>> key) {
        ImmutableList list = (ImmutableList)this.get((MapAccessor)key);
        return list == null ? Collections.emptyList() : list.asList();
    }

    private List<String> getStringList(Key<? extends ImmutableList<String>> key) {
        ImmutableList list = (ImmutableList)this.get((MapAccessor)key);
        return list == null ? Collections.emptyList() : list.asList();
    }

    @Override
    public void reshapeInLocal(Transform transform) {
        Bounds b = this.getLayoutBounds();
        b = transform.transform(b);
        this.reshapeInLocal(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        this.set((MapAccessor)WIDTH, width.abs());
        this.set((MapAccessor)HEIGHT, height.abs());
    }

    @Override
    public void stylesheetChanged(RenderContext ctx) {
        if (this.styleManager != null) {
            this.styleManager.setStylesheets(StyleOrigin.USER_AGENT, (URI)this.get((MapAccessor)DOCUMENT_HOME), this.getList((Key<? extends ImmutableList<URI>>)USER_AGENT_STYLESHEETS));
            this.styleManager.setStylesheets(StyleOrigin.AUTHOR, (URI)this.get((MapAccessor)DOCUMENT_HOME), this.getList((Key<? extends ImmutableList<URI>>)AUTHOR_STYLESHEETS));
            this.styleManager.setStylesheets(StyleOrigin.INLINE, this.getStringList((Key<? extends ImmutableList<String>>)INLINE_STYLESHEETS));
        }
        super.stylesheetChanged(ctx);
    }

    @Override
    public void updateNode(RenderContext ctx, Node n) {
        Pane g = (Pane)n;
        Bounds bounds = this.getLayoutBounds();
        g.setPrefWidth(bounds.getWidth());
        g.setPrefHeight(bounds.getHeight());
        g.resizeRelocate(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
        this.updateBackground(ctx, g);
        g.setClip((Node)new Rectangle(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight()));
        Group gg = (Group)g.getChildren().getFirst();
        ArrayList<Node> nodes = new ArrayList<Node>(this.getChildren().size());
        for (Figure child : this.getChildren()) {
            nodes.add(ctx.getNode(child));
        }
        ObservableList group = gg.getChildren();
        if (!group.equals(nodes)) {
            group.setAll(nodes);
        }
    }

    public void updateBackground(RenderContext ctx, Pane g) {
        Paint paint = Paintable.getPaint((Paintable)this.getStyled((MapAccessor)BACKGROUND));
        if (paint instanceof Color && ((Color)paint).getOpacity() == 0.0) {
            paint = null;
        }
        g.setBackground(paint == null ? null : new Background(new BackgroundFill[]{new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    @Override
    public boolean isSuitableParent(Figure newParent) {
        return true;
    }
}

