/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.LinkedHashSet;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.geometry.Point2D;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.LineConnectingFigure;
import org.jhotdraw8.draw.figure.NonTransformableFigure;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.facade.ReadOnlySetFacade;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;

public abstract class AbstractLineConnectionFigure
extends AbstractLeafFigure
implements NonTransformableFigure,
LineConnectingFigure {
    private final ReadOnlyBooleanWrapper connected = new ReadOnlyBooleanWrapper();

    public AbstractLineConnectionFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public AbstractLineConnectionFigure(Point2D start, Point2D end) {
        this(start.getX(), start.getY(), end.getX(), end.getY());
    }

    public AbstractLineConnectionFigure(double startX, double startY, double endX, double endY) {
        if (startX != 0.0) {
            this.set((MapAccessor)START_X, CssSize.of((double)startX));
        }
        if (startY != 0.0) {
            this.set((MapAccessor)START_Y, CssSize.of((double)startY));
        }
        if (endX != 0.0) {
            this.set((MapAccessor)END_X, CssSize.of((double)endX));
        }
        if (endY != 0.0) {
            this.set((MapAccessor)END_Y, CssSize.of((double)endY));
        }
    }

    @Override
    protected <T> void onPropertyChanged(Key<T> key, @Nullable T oldValue, @Nullable T newValue, boolean wasAdded, boolean wasRemoved) {
        if (key == START_TARGET) {
            if (this.getDrawing() != null) {
                if (oldValue != null && this.get((MapAccessor)END_TARGET) != oldValue) {
                    ((Figure)oldValue).getLayoutObservers().remove(this);
                }
                if (newValue != null) {
                    ((Figure)newValue).getLayoutObservers().add(this);
                }
            }
            this.updateConnectedProperty();
        } else if (key == END_TARGET) {
            if (this.getDrawing() != null) {
                if (oldValue != null && this.get((MapAccessor)START_TARGET) != oldValue) {
                    ((Figure)oldValue).getLayoutObservers().remove(this);
                }
                if (newValue != null) {
                    ((Figure)newValue).getLayoutObservers().add(this);
                }
            }
            this.updateConnectedProperty();
        } else if (key == START_CONNECTOR) {
            this.updateConnectedProperty();
        } else if (key == END_CONNECTOR) {
            this.updateConnectedProperty();
        }
        super.onPropertyChanged(key, oldValue, newValue, wasAdded, wasRemoved);
    }

    @Override
    public void doAddedToDrawing(Drawing drawing) {
        Figure endTarget;
        Figure startTarget = (Figure)this.get((MapAccessor)START_TARGET);
        if (startTarget != null) {
            startTarget.getLayoutObservers().add(this);
        }
        if ((endTarget = (Figure)this.get((MapAccessor)END_TARGET)) != null && endTarget != startTarget) {
            endTarget.getLayoutObservers().add(this);
        }
    }

    @Override
    protected void doRemovedFromDrawing(Drawing drawing) {
        Figure endTarget;
        Figure startTarget = (Figure)this.get((MapAccessor)START_TARGET);
        if (startTarget != null) {
            startTarget.getLayoutObservers().remove(this);
        }
        if ((endTarget = (Figure)this.get((MapAccessor)END_TARGET)) != null && endTarget != startTarget) {
            endTarget.getLayoutObservers().remove(this);
        }
    }

    @Override
    public CssRectangle2D getCssLayoutBounds() {
        CssPoint2D start = (CssPoint2D)this.getNonNull(START);
        CssPoint2D end = (CssPoint2D)this.getNonNull(END);
        return new CssRectangle2D(CssSize.min((CssSize)start.getX(), (CssSize)end.getX()), CssSize.min((CssSize)start.getY(), (CssSize)end.getY()), start.getX().subtract(end.getX()).abs(), start.getY().subtract(end.getY()).abs());
    }

    @Override
    public ReadOnlySet<Figure> getLayoutSubjects() {
        Figure startTarget = (Figure)this.get((MapAccessor)START_TARGET);
        Figure endTarget = (Figure)this.get((MapAccessor)END_TARGET);
        if (startTarget == null && endTarget == null) {
            return ChampSet.of();
        }
        LinkedHashSet<Figure> ctf = new LinkedHashSet<Figure>();
        if (startTarget != null) {
            ctf.add(startTarget);
        }
        if (endTarget != null) {
            ctf.add(endTarget);
        }
        return new ReadOnlySetFacade(ctf);
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public boolean isLayoutable() {
        return true;
    }

    @Override
    public void removeAllLayoutSubjects() {
        this.set((MapAccessor)START_TARGET, null);
        this.set((MapAccessor)END_TARGET, null);
    }

    @Override
    public void removeLayoutSubject(Figure subject) {
        if (subject == this.get((MapAccessor)START_TARGET)) {
            this.set((MapAccessor)START_TARGET, null);
        }
        if (subject == this.get((MapAccessor)END_TARGET)) {
            this.set((MapAccessor)END_TARGET, null);
        }
    }

    @Override
    public void reshapeInLocal(Transform transform) {
        if (this.get((MapAccessor)START_TARGET) == null) {
            this.set((MapAccessor)START, new CssPoint2D(FXTransforms.transform((Transform)transform, (Point2D)((CssPoint2D)this.getNonNull(START)).getConvertedValue())));
        }
        if (this.get((MapAccessor)END_TARGET) == null) {
            this.set((MapAccessor)END, new CssPoint2D(FXTransforms.transform((Transform)transform, (Point2D)((CssPoint2D)this.getNonNull(END)).getConvertedValue())));
        }
    }

    @Override
    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        if (this.get((MapAccessor)START_TARGET) == null) {
            this.set((MapAccessor)START, new CssPoint2D(x, y));
        }
        if (this.get((MapAccessor)END_TARGET) == null) {
            this.set((MapAccessor)END, new CssPoint2D(x.add(width), y.add(height)));
        }
    }

    public void setEndConnection(Figure target, Connector connector) {
        this.set((MapAccessor)END_CONNECTOR, connector);
        this.set((MapAccessor)END_TARGET, target);
    }

    public void setStartConnection(Figure target, Connector connector) {
        this.set((MapAccessor)START_CONNECTOR, connector);
        this.set((MapAccessor)START_TARGET, target);
    }

    protected void updateConnectedProperty() {
        this.connected.set(this.get((MapAccessor)START_CONNECTOR) != null && this.get((MapAccessor)START_TARGET) != null && this.get((MapAccessor)END_CONNECTOR) != null && this.get((MapAccessor)END_TARGET) != null);
    }

    public ReadOnlyBooleanWrapper connectedProperty() {
        return this.connected;
    }
}

