/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.CssPoint2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.DoubleStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public class ArcFigure
extends AbstractLeafFigure
implements StrokableFigure,
FillableFigure,
TransformableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure {
    public static final String TYPE_SELECTOR = "Arc";
    public static final CssSizeStyleableKey CENTER_X = new CssSizeStyleableKey("centerX", CssSize.ZERO);
    public static final CssSizeStyleableKey CENTER_Y = new CssSizeStyleableKey("centerY", CssSize.ZERO);
    public static final CssSizeStyleableKey RADIUS_X = new CssSizeStyleableKey("radiusX", CssSize.ONE);
    public static final CssSizeStyleableKey RADIUS_Y = new CssSizeStyleableKey("radiusY", CssSize.ONE);
    public static final DoubleStyleableKey START_ANGLE = new DoubleStyleableKey("startAngle", 0.0);
    public static final DoubleStyleableKey ARC_LENGTH = new DoubleStyleableKey("arcLength", 360.0);
    public static final NonNullEnumStyleableKey<ArcType> ARC_TYPE = new NonNullEnumStyleableKey<ArcType>("arcType", ArcType.class, ArcType.ROUND);
    public static final CssPoint2DStyleableMapAccessor CENTER = new CssPoint2DStyleableMapAccessor("center", (NonNullMapAccessor<CssSize>)CENTER_X, (NonNullMapAccessor<CssSize>)CENTER_Y);
    public static final CssPoint2DStyleableMapAccessor RADIUS = new CssPoint2DStyleableMapAccessor("radius", (NonNullMapAccessor<CssSize>)RADIUS_X, (NonNullMapAccessor<CssSize>)RADIUS_Y);

    public ArcFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public ArcFigure(double x, double y, double width, double height) {
        this.reshapeInLocal(x, y, width, height);
    }

    public ArcFigure(Rectangle2D rect) {
        this.reshapeInLocal(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public Bounds getLayoutBounds() {
        double rx = ((CssSize)this.getNonNull((NonNullMapAccessor)RADIUS_X)).getConvertedValue();
        double ry = ((CssSize)this.getNonNull((NonNullMapAccessor)RADIUS_Y)).getConvertedValue();
        double cx = ((CssSize)this.getNonNull((NonNullMapAccessor)CENTER_X)).getConvertedValue();
        double cy = ((CssSize)this.getNonNull((NonNullMapAccessor)CENTER_Y)).getConvertedValue();
        return new BoundingBox(cx - rx, cy - ry, rx * 2.0, ry * 2.0);
    }

    @Override
    public CssRectangle2D getCssLayoutBounds() {
        CssSize rx = (CssSize)this.getNonNull((NonNullMapAccessor)RADIUS_X);
        CssSize ry = (CssSize)this.getNonNull((NonNullMapAccessor)RADIUS_Y);
        CssSize cx = (CssSize)this.getNonNull((NonNullMapAccessor)CENTER_X);
        CssSize cy = (CssSize)this.getNonNull((NonNullMapAccessor)CENTER_Y);
        return new CssRectangle2D(cx.subtract(rx), cy.subtract(ry), rx.multiply(2.0), ry.multiply(2.0));
    }

    @Override
    public void reshapeInLocal(Transform transform) {
        Bounds r = this.getLayoutBounds();
        BoundingBox b = new BoundingBox(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
        b = transform.transform((Bounds)b);
        this.reshapeInLocal(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        CssSize rx = width.getValue() > 0.0 ? width.multiply(0.5) : CssSize.ZERO;
        CssSize ry = height.getValue() > 0.0 ? height.multiply(0.5) : CssSize.ZERO;
        this.set((MapAccessor)CENTER_X, x.add(rx));
        this.set((MapAccessor)CENTER_Y, y.add(ry));
        this.set((MapAccessor)RADIUS_X, rx);
        this.set((MapAccessor)RADIUS_Y, ry);
    }

    @Override
    public Node createNode(RenderContext drawingView) {
        Arc n = new Arc();
        n.setManaged(false);
        return n;
    }

    @Override
    public void updateNode(RenderContext ctx, Node node) {
        Arc n = (Arc)node;
        this.applyHideableFigureProperties(ctx, (Node)n);
        this.applyTransformableFigureProperties(ctx, (Node)n);
        this.applyStrokableFigureProperties(ctx, (Shape)n);
        this.applyFillableFigureProperties(ctx, (Shape)n);
        this.applyCompositableFigureProperties(ctx, (Node)n);
        this.applyStyleableFigureProperties(ctx, node);
        n.setCenterX(((CssSize)this.getStyledNonNull(CENTER_X)).getConvertedValue());
        n.setCenterY(((CssSize)this.getStyledNonNull(CENTER_Y)).getConvertedValue());
        n.setRadiusX(((CssSize)this.getStyledNonNull(RADIUS_X)).getConvertedValue());
        n.setRadiusY(((CssSize)this.getStyledNonNull(RADIUS_Y)).getConvertedValue());
        n.setStartAngle(((Double)this.getStyledNonNull(START_ANGLE)).doubleValue());
        n.setLength(((Double)this.getStyledNonNull(ARC_LENGTH)).doubleValue());
        n.setType((ArcType)this.getStyled((MapAccessor)ARC_TYPE));
        n.applyCss();
    }

    public String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

