/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.stream.Stream;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import org.jhotdraw8.collection.iterator.Iterators;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.geom.BoundsCalculator;

public class Figures {
    private Figures() {
    }

    public static Bounds getBoundsInWorld(Iterable<? extends Figure> figures) {
        return ((Stream)Iterators.toList(figures).stream().parallel()).map(Figure::getLayoutBoundsInWorld).filter(b -> Double.isFinite(b.getMaxX()) && Double.isFinite(b.getMaxY())).collect(BoundsCalculator::new, BoundsCalculator::accept, BoundsCalculator::combine).getBounds();
    }

    public static Bounds getCenterBounds(Iterable<? extends Figure> figures) {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        for (Figure figure : figures) {
            Bounds b = figure.localToWorld(figure.getLayoutBounds());
            double cx = b.getMinX() + b.getWidth() * 0.5;
            double cy = b.getMinY() + b.getHeight() * 0.5;
            minx = Math.min(minx, cx);
            maxx = Double.max(maxx, cx);
            miny = Math.min(miny, cy);
            maxy = Double.max(maxy, cy);
        }
        return new BoundingBox(minx, miny, maxx - minx, maxy - miny);
    }
}

