/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssTransforms;
import org.jhotdraw8.draw.figure.AbstractCompositeFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Grouping;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.render.RenderContext;

public class GroupFigure
extends AbstractCompositeFigure
implements Grouping,
ResizableFigure,
TransformableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure {
    public static final String TYPE_SELECTOR = "Group";

    @Override
    public Node createNode(RenderContext drawingView) {
        Group n = new Group();
        n.setAutoSizeChildren(false);
        n.setManaged(false);
        return n;
    }

    public String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public void reshapeInLocal(Transform transform) {
        this.flattenTransforms();
        for (Figure child : this.getChildren()) {
            child.reshapeInParent(transform);
        }
    }

    @Override
    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        this.flattenTransforms();
        Transform localTransform = CssTransforms.createReshapeTransform(this.getCssLayoutBounds(), x, y, width, height);
        for (Figure child : this.getChildren()) {
            child.reshapeInParent(localTransform);
        }
    }

    @Override
    public void updateNode(RenderContext ctx, Node n) {
        this.applyHideableFigureProperties(ctx, n);
        this.applyTransformableFigureProperties(ctx, n);
        this.applyStyleableFigureProperties(ctx, n);
        this.applyCompositableFigureProperties(ctx, n);
        ArrayList<Node> nodes = new ArrayList<Node>(this.getChildren().size());
        for (Figure child : this.getChildren()) {
            nodes.add(ctx.getNode(child));
        }
        ObservableList group = ((Group)n).getChildren();
        if (!group.equals(nodes)) {
            group.setAll(nodes);
        }
    }

    @Override
    public boolean isSuitableParent(Figure newParent) {
        return true;
    }

    @Override
    public boolean isSuitableChild(Figure newChild) {
        return true;
    }
}

