/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssFont;
import org.jhotdraw8.draw.figure.AbstractCompositeFigure;
import org.jhotdraw8.draw.figure.Clipping;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.NonTransformableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXRectangles;
import org.jspecify.annotations.Nullable;

public class LayerFigure
extends AbstractCompositeFigure
implements Layer,
StyleableFigure,
HideableFigure,
LockableFigure,
NonTransformableFigure,
CompositableFigure {
    private static final int MIN_NODES_FOR_CLIPPING = 100;

    @Override
    public void reshapeInLocal(Transform transform) {
        for (Figure child : this.getChildren()) {
            child.reshapeInLocal(transform);
        }
    }

    @Override
    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
    }

    @Override
    public void updateNode(RenderContext ctx, Node node) {
        ObservableList groupChildren;
        List<Object> childNodes;
        Group n = (Group)node;
        this.applyHideableFigureProperties(ctx, (Node)n);
        RenderingIntent renderingIntent = (RenderingIntent)((Object)ctx.get((MapAccessor)RenderContext.RENDERING_INTENT));
        if (!this.isVisible() && renderingIntent == RenderingIntent.EDITOR) {
            return;
        }
        this.applyStyleableFigureProperties(ctx, (Node)n);
        this.applyCompositableFigureProperties(ctx, (Node)n);
        int maxNodesPerLayer = (Integer)ctx.getNonNull((NonNullMapAccessor)RenderContext.MAX_NODES_PER_LAYER);
        Bounds clipBounds = (Bounds)ctx.get((MapAccessor)RenderContext.CLIP_BOUNDS);
        if (renderingIntent == RenderingIntent.EDITOR && clipBounds != null && this.getChildren().size() > 100) {
            childNodes = ((Stream)this.getChildren().stream().parallel()).filter(child -> child.getVisualBoundsInWorld().intersects(clipBounds)).toList().stream().map(ctx::getNode).collect(Collectors.toList());
            if (childNodes.size() > maxNodesPerLayer) {
                this.updateNodeWithErrorMessage(ctx, childNodes, clipBounds);
            }
        } else {
            childNodes = new ArrayList<Node>();
            for (Figure child2 : this.getChildren()) {
                childNodes.add(ctx.getNode(child2));
            }
        }
        if (!(groupChildren = n.getChildren()).equals(childNodes)) {
            groupChildren.setAll(childNodes);
        }
    }

    public void updateNodeWithErrorMessage(RenderContext ctx, List<Node> childNodes, Bounds clipBounds) {
        Drawing drawing = this.getDrawing();
        Bounds b = drawing != null ? drawing.getLayoutBounds() : new BoundingBox(0.0, 0.0, 100.0, 100.0);
        Rectangle r = new Rectangle(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
        UnitConverter unitConverter = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double delta = unitConverter.convert(1.0, "vmin", "");
        Color red = new Color(1.0, 0.0, 0.0, 0.1);
        Text text = new Text();
        double fontSize = unitConverter.convert(1.6, "vmin", "");
        text.setFont(CssFont.font("Arial", FontWeight.NORMAL, FontPosture.REGULAR, fontSize).getFont());
        text.setText("Layer \"" + this.getId() + "\" has too many children: " + this.getChildren().size() + ".");
        text.setFill((Paint)Color.RED);
        text.setStroke((Paint)Color.WHITE);
        text.setStrokeWidth(unitConverter.convert(0.2, "vmin", ""));
        text.setStrokeType(StrokeType.OUTSIDE);
        text.setX(Math.max(fontSize, clipBounds.getMinX() + fontSize));
        if (this.getParent() != null) {
            int countVisibleLayersBeforeMe = 0;
            for (Figure child : this.getParent().getChildren()) {
                if (Boolean.TRUE.equals(child.get((MapAccessor)HideableFigure.VISIBLE))) {
                    ++countVisibleLayersBeforeMe;
                }
                if (child != this) continue;
                break;
            }
            text.setY(Math.max(0.0, clipBounds.getMinY()) + text.getLayoutBounds().getHeight() * 1.2 * (double)(1 + countVisibleLayersBeforeMe));
        } else {
            text.setY(Math.max(0.0, clipBounds.getMinY()) + text.getLayoutBounds().getHeight() * 1.2);
        }
        Bounds tb = text.getLayoutBounds();
        tb = FXRectangles.grow((Bounds)tb, (double)unitConverter.convert(0.1, "vmin", ""));
        r.setX(tb.getMinX());
        r.setY(tb.getMinY());
        r.setWidth(tb.getWidth());
        r.setHeight(tb.getHeight());
        Color transparent = Color.TRANSPARENT;
        r.setFill((Paint)new LinearGradient(r.getX(), r.getY(), r.getX() + delta, r.getY() + delta, false, CycleMethod.REPEAT, new Stop[]{new Stop(0.5, red), new Stop(0.5, transparent)}));
        childNodes.clear();
        childNodes.add((Node)r);
        childNodes.add((Node)text);
    }

    @Override
    public Node createNode(RenderContext ctx) {
        Group n = new Group();
        n.setManaged(false);
        n.setAutoSizeChildren(false);
        return n;
    }

    protected void checkNewParent(@Nullable Figure newValue) {
        if (newValue != null && !(newValue instanceof Drawing) && !(newValue instanceof Clipping)) {
            throw new IllegalArgumentException("A Layer can only be added as a child to a Drawing. Illegal parent: " + String.valueOf(newValue));
        }
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void createHandles(HandleType handleType, List<Handle> list) {
    }

    @Override
    public boolean isSuitableChild(Figure newChild) {
        return true;
    }

    public String toString() {
        return "LayerFigure@" + Integer.toHexString(System.identityHashCode(this)) + "{" + this.getId() + "}";
    }

    @Override
    public Bounds getBoundsInLocal() {
        return new BoundingBox(0.0, 0.0, Double.MAX_VALUE, Double.MAX_VALUE);
    }
}

