/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.Arrays;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.print.Paper;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.draw.css.value.CssDimension2D;
import org.jhotdraw8.draw.figure.Clipping;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;

public interface Page
extends Figure {
    public static final List<Paper> PAPERS = Arrays.asList(Paper.A0, Paper.A1, Paper.A2, Paper.A3, Paper.A4, Paper.A5, Paper.A6, Paper.DESIGNATED_LONG, Paper.NA_LETTER, Paper.LEGAL, Paper.TABLOID, Paper.EXECUTIVE, Paper.NA_8X10, Paper.MONARCH_ENVELOPE, Paper.NA_NUMBER_10_ENVELOPE, Paper.C, Paper.JIS_B4, Paper.JIS_B5, Paper.JIS_B6, Paper.JAPANESE_POSTCARD);

    public Node createPageNode(int var1);

    default public Paper createPaper(int internalPageNumber) {
        CssDimension2D size = this.getPaperSize();
        DefaultUnitConverter c = new DefaultUnitConverter(72.0);
        double w = c.convert(size.getWidth(), "pt");
        double h = c.convert(size.getHeight(), "pt");
        for (Paper p : PAPERS) {
            if ((p.getWidth() != w || p.getHeight() != h) && (p.getHeight() != w || p.getWidth() != h)) continue;
            return p;
        }
        return Paper.A4;
    }

    public int getNumberOfSubPages();

    public Bounds getPageBounds(int var1);

    public Shape getPageClip(int var1);

    public Transform getPageTransform(int var1);

    public CssDimension2D getPaperSize();

    @Override
    default public boolean isAllowsChildren() {
        return true;
    }

    @Override
    default public boolean isSuitableParent(Figure newParent) {
        return newParent instanceof Layer || newParent instanceof Clipping;
    }
}

