/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AbstractLabelFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TextFontableFigure;
import org.jhotdraw8.draw.figure.TextLayoutableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.StringStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public class PageLabelFigure
extends AbstractLabelFigure
implements HideableFigure,
TextFontableFigure,
TextLayoutableFigure,
StyleableFigure,
LockableFigure,
TransformableFigure,
CompositableFigure {
    public static final String TYPE_SELECTOR = "PageLabel";
    public static final String NUM_PAGES_PLACEHOLDER = "${numPages}";
    public static final String PAGE_PLACEHOLDER = "${page}";
    public static final String DATE_PLACEHOLDER = "${date}";
    public static final StringStyleableKey TEXT_WITH_PLACEHOLDERS = new StringStyleableKey("text", "", "Supported placeholders:  ${page}, ${numPages}, ${date}");

    public PageLabelFigure() {
        this(0.0, 0.0, "", new Object[0]);
    }

    public PageLabelFigure(Point2D position, String text) {
        this(position.getX(), position.getY(), text, new Object[0]);
    }

    public PageLabelFigure(double x, double y, String text, Object ... keyValues) {
        this.set((MapAccessor)TEXT_WITH_PLACEHOLDERS, text);
        this.set((MapAccessor)ORIGIN, new CssPoint2D(x, y));
        for (int i = 0; i < keyValues.length; i += 2) {
            Key key = (Key)keyValues[i];
            this.set((MapAccessor)key, keyValues[i + 1]);
        }
    }

    @Override
    protected String getText(RenderContext ctx) {
        String date;
        String text = (String)this.getNonNull((NonNullMapAccessor)TEXT_WITH_PLACEHOLDERS);
        Integer pageNumber = ctx == null ? Integer.valueOf(0) : (Integer)ctx.get((MapAccessor)RenderContext.RENDER_PAGE_NUMBER);
        Integer numPages = ctx == null ? Integer.valueOf(0) : (Integer)ctx.get((MapAccessor)RenderContext.RENDER_NUMBER_OF_PAGES);
        Instant timestamp = ctx == null ? Instant.now() : (Instant)ctx.get((MapAccessor)RenderContext.RENDER_TIMESTAMP);
        String string = date = timestamp == null ? null : DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).format(timestamp.atZone(ZoneId.systemDefault()).toLocalDate());
        if (pageNumber != null) {
            text = this.replaceAll(text, PAGE_PLACEHOLDER, "" + (pageNumber + 1));
        }
        if (numPages != null) {
            text = this.replaceAll(text, NUM_PAGES_PLACEHOLDER, "" + numPages);
        }
        if (date != null) {
            text = this.replaceAll(text, DATE_PLACEHOLDER, date);
        }
        return text;
    }

    private String replaceAll(String text, String placeholder, String replace) {
        int p = ((String)text).indexOf(placeholder);
        while (p != -1) {
            text = ((String)text).substring(0, p) + replace + ((String)text).substring(p + placeholder.length());
            p = ((String)text).indexOf(placeholder);
        }
        return text;
    }

    @Override
    public void updateNode(RenderContext ctx, Node node) {
        super.updateNode(ctx, node);
        this.applyTransformableFigureProperties(ctx, node);
        this.applyCompositableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyHideableFigureProperties(ctx, node);
    }

    public String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

