/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.Collection;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssInsets;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.CssInsetsStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.DoubleStyleableKey;
import org.jhotdraw8.draw.key.NullableFXPathElementsStyleableKey;
import org.jhotdraw8.draw.key.Rectangle2DStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.BoundingBoxBuilder;
import org.jhotdraw8.geom.FXPathElementsBuilder;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.NineRegionsScalingBuilder;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface ShapeableFigure
extends Figure {
    public static final CssSizeStyleableKey SHAPE_SLICE_BOTTOM = new CssSizeStyleableKey("shapeSliceBottom", CssSize.ZERO);
    public static final CssSizeStyleableKey SHAPE_SLICE_LEFT = new CssSizeStyleableKey("shapeSliceLeft", CssSize.ZERO);
    public static final CssSizeStyleableKey SHAPE_SLICE_RIGHT = new CssSizeStyleableKey("shapeSliceRight", CssSize.ZERO);
    public static final CssSizeStyleableKey SHAPE_SLICE_TOP = new CssSizeStyleableKey("shapeSliceTop", CssSize.ZERO);
    public static final CssInsetsStyleableMapAccessor SHAPE_SLICE = new CssInsetsStyleableMapAccessor("shapeSlice", (NonNullMapAccessor<CssSize>)SHAPE_SLICE_TOP, (NonNullMapAccessor<CssSize>)SHAPE_SLICE_RIGHT, (NonNullMapAccessor<CssSize>)SHAPE_SLICE_BOTTOM, (NonNullMapAccessor<CssSize>)SHAPE_SLICE_LEFT);
    public static final DoubleStyleableKey SHAPE_BOUNDS_X = new DoubleStyleableKey("shapeBoundsX", 0.0);
    public static final DoubleStyleableKey SHAPE_BOUNDS_Y = new DoubleStyleableKey("shapeBoundsY", 0.0);
    public static final DoubleStyleableKey SHAPE_BOUNDS_WIDTH = new DoubleStyleableKey("shapeBoundsWidth", 0.0);
    public static final DoubleStyleableKey SHAPE_BOUNDS_HEIGHT = new DoubleStyleableKey("shapeBoundsHeight", 0.0);
    public static final Rectangle2DStyleableMapAccessor SHAPE_BOUNDS = new Rectangle2DStyleableMapAccessor("shapeBounds", (NonNullMapAccessor<Double>)SHAPE_BOUNDS_X, (NonNullMapAccessor<Double>)SHAPE_BOUNDS_Y, (NonNullMapAccessor<Double>)SHAPE_BOUNDS_WIDTH, (NonNullMapAccessor<Double>)SHAPE_BOUNDS_HEIGHT);
    public static final NullableFXPathElementsStyleableKey SHAPE = new NullableFXPathElementsStyleableKey("shape", null);
    public static final ImmutableList<PathElement> SVG_SQUARE = VectorList.of((Object[])new PathElement[]{new MoveTo(0.0, 0.0), new LineTo(1.0, 0.0), new LineTo(1.0, 1.0), new LineTo(0.0, 1.0), new ClosePath()});

    default public void applyShapeableProperties(RenderContext ctx, Path node) {
        this.applyShapeableProperties(ctx, node, this.getLayoutBounds());
    }

    default public void applyShapeableProperties(RenderContext ctx, Path node, Bounds b) {
        Rectangle2D shapeBounds;
        ImmutableList<PathElement> content = (ImmutableList<PathElement>)this.getStyled((MapAccessor)SHAPE);
        if (content == null || content.isEmpty()) {
            content = SVG_SQUARE;
        }
        Bounds srcBounds = (shapeBounds = (Rectangle2D)this.getStyled((MapAccessor)SHAPE_BOUNDS)) == null || FXRectangles.isEmpty((Rectangle2D)shapeBounds) ? ((BoundingBoxBuilder)FXShapes.buildPathElements((PathBuilder)new BoundingBoxBuilder(), content)).build() : FXRectangles.getBounds((Rectangle2D)shapeBounds);
        Insets shapeSlice = ((CssInsets)this.getStyledNonNull(SHAPE_SLICE)).getConvertedValue(srcBounds.getWidth(), srcBounds.getHeight());
        FXPathElementsBuilder builder2 = new FXPathElementsBuilder();
        NineRegionsScalingBuilder nineRegionsScalingBuilder = new NineRegionsScalingBuilder((PathBuilder)builder2, srcBounds, shapeSlice, b);
        FXShapes.buildPathElements((PathBuilder)nineRegionsScalingBuilder, content);
        List elements = (List)nineRegionsScalingBuilder.build();
        node.getElements().setAll((Collection)elements);
        node.setVisible(true);
    }
}

