/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.Slice;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.BoundsInLocalOutlineHandle;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.RelativePointHandle;
import org.jhotdraw8.draw.handle.ResizeHandleKit;
import org.jhotdraw8.draw.key.CssPoint2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssRectangle2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public class SliceFigure
extends AbstractLeafFigure
implements Slice,
TransformableFigure,
ResizableFigure,
HideableFigure,
LockableFigure,
StyleableFigure {
    public static final String TYPE_SELECTOR = "Slice";
    public static final CssSizeStyleableKey X = new CssSizeStyleableKey("x", CssSize.ZERO);
    public static final CssSizeStyleableKey Y = new CssSizeStyleableKey("y", CssSize.ZERO);
    public static final CssSizeStyleableKey WIDTH = new CssSizeStyleableKey("width", CssSize.ZERO);
    public static final CssSizeStyleableKey HEIGHT = new CssSizeStyleableKey("height", CssSize.ZERO);
    public static final CssRectangle2DStyleableMapAccessor BOUNDS = new CssRectangle2DStyleableMapAccessor("bounds", (NonNullMapAccessor<CssSize>)X, (NonNullMapAccessor<CssSize>)Y, (NonNullMapAccessor<CssSize>)WIDTH, (NonNullMapAccessor<CssSize>)HEIGHT);
    public static final CssSizeStyleableKey SLICE_ORIGIN_X = new CssSizeStyleableKey("sliceOriginX", CssSize.ZERO);
    public static final CssSizeStyleableKey SLICE_ORIGIN_Y = new CssSizeStyleableKey("sliceOriginY", CssSize.ZERO);
    public static final CssPoint2DStyleableMapAccessor SLICE_ORIGIN = new CssPoint2DStyleableMapAccessor("sliceOrigin", (NonNullMapAccessor<CssSize>)SLICE_ORIGIN_X, (NonNullMapAccessor<CssSize>)SLICE_ORIGIN_Y);

    public SliceFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public SliceFigure(double x, double y, double width, double height) {
        this.reshapeInLocal(x, y, width, height);
    }

    public SliceFigure(Rectangle2D rect) {
        this(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public void createHandles(HandleType handleType, List<Handle> list) {
        if (handleType == HandleType.POINT) {
            list.add(new BoundsInLocalOutlineHandle(this));
            ResizeHandleKit.addCornerResizeHandles(this, list);
            list.add(new RelativePointHandle(this, (MapAccessor<CssPoint2D>)SLICE_ORIGIN));
        } else {
            super.createHandles(handleType, list);
        }
    }

    @Override
    public Bounds getLayoutBounds() {
        return new BoundingBox(((CssSize)this.get((MapAccessor)X)).getConvertedValue(), ((CssSize)this.get((MapAccessor)Y)).getConvertedValue(), ((CssSize)this.get((MapAccessor)WIDTH)).getConvertedValue(), ((CssSize)this.get((MapAccessor)HEIGHT)).getConvertedValue());
    }

    @Override
    public CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D((CssSize)this.get((MapAccessor)X), (CssSize)this.get((MapAccessor)Y), (CssSize)this.get((MapAccessor)WIDTH), (CssSize)this.get((MapAccessor)HEIGHT));
    }

    @Override
    public Point2D getSliceOrigin() {
        Bounds b = this.getLayoutBounds();
        Point2D p = ((CssPoint2D)this.getNonNull(SLICE_ORIGIN)).getConvertedValue();
        return p.add(b.getMinX(), b.getMinY());
    }

    @Override
    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        this.set((MapAccessor)X, width.getValue() < 0.0 ? x.add(width) : x);
        this.set((MapAccessor)Y, height.getValue() < 0.0 ? y.add(height) : y);
        this.set((MapAccessor)WIDTH, width.abs());
        this.set((MapAccessor)HEIGHT, height.abs());
    }

    @Override
    public Node createNode(RenderContext drawingView) {
        Rectangle node = new Rectangle();
        node.setFill((Paint)new Color(0.0, 1.0, 0.0, 0.5));
        node.setStroke((Paint)Color.DARKRED);
        node.setStrokeType(StrokeType.INSIDE);
        return node;
    }

    @Override
    public void updateNode(RenderContext ctx, Node node) {
        Rectangle rectangleNode = (Rectangle)node;
        this.applyHideableFigureProperties(ctx, node);
        if (ctx.get((MapAccessor)RenderContext.RENDERING_INTENT) != RenderingIntent.EDITOR) {
            rectangleNode.setVisible(false);
        }
        this.applyTransformableFigureProperties(ctx, (Node)rectangleNode);
        rectangleNode.setX(((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue());
        rectangleNode.setY(((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue());
        rectangleNode.setWidth(((CssSize)this.getNonNull((NonNullMapAccessor)WIDTH)).getConvertedValue());
        rectangleNode.setHeight(((CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT)).getConvertedValue());
    }

    public String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public boolean isSuitableParent(Figure newParent) {
        return Slice.super.isSuitableParent(newParent);
    }

    @Override
    public Bounds getBoundsInLocal() {
        return this.getLayoutBounds();
    }
}

