/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.BasicStroke;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import javafx.geometry.Bounds;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.key.NonNullListStyleableKey;
import org.jhotdraw8.draw.key.NullablePaintableStyleableKey;
import org.jhotdraw8.draw.key.StrokeStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public interface StrokableFigure
extends Figure {
    public static final CssSizeStyleableKey STROKE_DASH_OFFSET = new CssSizeStyleableKey("stroke-dashoffset", CssSize.ZERO);
    public static final NonNullEnumStyleableKey<StrokeLineCap> STROKE_LINE_CAP = new NonNullEnumStyleableKey<StrokeLineCap>("stroke-linecap", StrokeLineCap.class, StrokeLineCap.BUTT);
    public static final NonNullEnumStyleableKey<StrokeLineJoin> STROKE_LINE_JOIN = new NonNullEnumStyleableKey<StrokeLineJoin>("stroke-linejoin", StrokeLineJoin.class, StrokeLineJoin.MITER);
    public static final CssSizeStyleableKey STROKE_MITER_LIMIT = new CssSizeStyleableKey("stroke-miterlimit", CssSize.of((double)4.0));
    public static final NullablePaintableStyleableKey STROKE = new NullablePaintableStyleableKey("stroke", new CssColor("canvastext", Color.BLACK));
    public static final NonNullEnumStyleableKey<StrokeType> STROKE_TYPE = new NonNullEnumStyleableKey<StrokeType>("stroke-type", StrokeType.class, StrokeType.CENTERED);
    public static final CssSizeStyleableKey STROKE_WIDTH = new CssSizeStyleableKey("stroke-width", CssSize.ONE);
    public static final NonNullListStyleableKey<CssSize> STROKE_DASH_ARRAY = new NonNullListStyleableKey("stroke-dasharray", (Type)((Object)CssSize.class), new SizeCssConverter(false), VectorList.of());
    public static final @Nullable StrokeStyleableMapAccessor STROKE_STYLE = new StrokeStyleableMapAccessor("stroke-style", (MapAccessor<StrokeType>)STROKE_TYPE, (MapAccessor<StrokeLineCap>)STROKE_LINE_CAP, (MapAccessor<StrokeLineJoin>)STROKE_LINE_JOIN, (MapAccessor<CssSize>)STROKE_MITER_LIMIT, (MapAccessor<CssSize>)STROKE_DASH_OFFSET, (MapAccessor<ImmutableList<CssSize>>)STROKE_DASH_ARRAY);

    default public void applyStrokeCapAndJoinProperties(RenderContext ctx, Shape shape) {
        StrokeLineCap slp = (StrokeLineCap)this.getStyled((MapAccessor)STROKE_LINE_CAP);
        if (shape.getStrokeLineCap() != slp) {
            shape.setStrokeLineCap(slp);
        }
        StrokeLineJoin slj = (StrokeLineJoin)this.getStyled((MapAccessor)STROKE_LINE_JOIN);
        if (shape.getStrokeLineJoin() != slj) {
            shape.setStrokeLineJoin(slj);
        }
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)STROKE_MITER_LIMIT)).getConvertedValue();
        if (shape.getStrokeMiterLimit() != d) {
            shape.setStrokeMiterLimit(d);
        }
    }

    default public void applyStrokeDashProperties(RenderContext ctx, Shape shape) {
        ImmutableList dashArray;
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)STROKE_DASH_OFFSET)).getConvertedValue();
        if (shape.getStrokeDashOffset() != d) {
            shape.setStrokeDashOffset(d);
        }
        if ((dashArray = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)STROKE_DASH_ARRAY)).isEmpty()) {
            shape.getStrokeDashArray().clear();
        } else {
            ArrayList<Double> list = new ArrayList<Double>(dashArray.size());
            for (CssSize sz : dashArray) {
                list.add(sz.getConvertedValue());
            }
            shape.getStrokeDashArray().setAll(list);
        }
    }

    default public void applyStrokeTypeProperties(RenderContext ctx, Shape shape) {
        StrokeType st = (StrokeType)this.getStyled((MapAccessor)STROKE_TYPE);
        if (shape.getStrokeType() != st) {
            shape.setStrokeType(st);
        }
    }

    default public void applyStrokableFigureProperties(@Nullable RenderContext ctx, Shape shape) {
        this.applyStrokeColorProperties(ctx, shape);
        this.applyStrokeWidthProperties(ctx, shape);
        this.applyStrokeCapAndJoinProperties(ctx, shape);
        this.applyStrokeTypeProperties(ctx, shape);
        this.applyStrokeDashProperties(ctx, shape);
    }

    default public void applyStrokeColorProperties(@Nullable RenderContext ctx, Shape shape) {
        Paint p = Paintable.getPaint((Paintable)this.getStyled((MapAccessor)STROKE), ctx);
        if (!Objects.equals(shape.getStroke(), p)) {
            shape.setStroke(p);
        }
    }

    default public void applyStrokeWidthProperties(@Nullable RenderContext ctx, Shape shape) {
        double width;
        CssSize cssSize = (CssSize)this.getStyledNonNull((NonNullMapAccessor)STROKE_WIDTH);
        double d = width = ctx == null ? cssSize.getConvertedValue() : ((UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY)).convert(cssSize, "");
        if (shape.getStrokeWidth() != width) {
            shape.setStrokeWidth(width);
        }
    }

    default public BasicStroke getStyledStroke(@Nullable RenderContext ctx) {
        float[] dasharray;
        CssSize cssSize = (CssSize)this.getStyledNonNull((NonNullMapAccessor)STROKE_WIDTH);
        double width = ctx == null ? cssSize.getConvertedValue() : ((UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY)).convert(cssSize, "");
        StrokeLineCap cap = (StrokeLineCap)this.getStyledNonNull((NonNullMapAccessor)STROKE_LINE_CAP);
        int basicCap = switch (cap) {
            default -> 0;
            case StrokeLineCap.ROUND -> 1;
            case StrokeLineCap.SQUARE -> 2;
        };
        ImmutableList dashlist = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)STROKE_DASH_ARRAY);
        if (dashlist.isEmpty()) {
            dasharray = null;
        } else {
            dasharray = new float[dashlist.size()];
            int i = 0;
            for (CssSize sz : dashlist) {
                dasharray[i++] = (float)sz.getConvertedValue();
            }
        }
        double dashoffset = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)STROKE_DASH_OFFSET)).getConvertedValue();
        StrokeLineJoin join = (StrokeLineJoin)this.getStyledNonNull((NonNullMapAccessor)STROKE_LINE_JOIN);
        int basicJoin = switch (join) {
            default -> 2;
            case StrokeLineJoin.MITER -> 0;
            case StrokeLineJoin.ROUND -> 1;
        };
        double miterlimit = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)STROKE_MITER_LIMIT)).getConvertedValue();
        return new BasicStroke((float)width, basicCap, basicJoin, (float)miterlimit, dasharray, (float)dashoffset);
    }

    @Override
    default public Bounds getBoundsInLocal() {
        Bounds layoutBounds = this.getLayoutBounds();
        Paintable paintable = (Paintable)this.get((MapAccessor)STROKE);
        if (paintable == null) {
            return layoutBounds;
        }
        double strokeWidth = ((CssSize)this.getNonNull((NonNullMapAccessor)STROKE_WIDTH)).getConvertedValue();
        if (strokeWidth == 0.0) {
            return layoutBounds;
        }
        StrokeType strokeType = (StrokeType)this.getNonNull((NonNullMapAccessor)STROKE_TYPE);
        return switch (strokeType) {
            default -> layoutBounds;
            case StrokeType.OUTSIDE -> FXRectangles.grow((Bounds)layoutBounds, (double)(strokeWidth * 2.0), (double)(strokeWidth * 2.0));
            case StrokeType.CENTERED -> FXRectangles.grow((Bounds)layoutBounds, (double)strokeWidth, (double)strokeWidth);
        };
    }
}

