/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.Collection;
import javafx.beans.property.ReadOnlyProperty;
import javafx.scene.Node;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.NullableStringStyleableKey;
import org.jhotdraw8.draw.key.StringReadOnlyStyleableKey;
import org.jhotdraw8.draw.key.WordSetKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.fxcollection.facade.ObservableSetFacade;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;

public interface StyleableFigure
extends Figure {
    public static final NullableStringStyleableKey ID = new NullableStringStyleableKey("id");
    public static final WordSetKey STYLE_CLASS = new WordSetKey("class", (ImmutableSet<String>)ChampSet.of());
    public static final WordSetKey PSEUDO_CLASS = new WordSetKey("pseudoClass", (ImmutableSet<String>)ChampSet.of());
    public static final StringReadOnlyStyleableKey STYLE = new StringReadOnlyStyleableKey("style");
    public static final String TYPE_SELECTOR_NODE_KEY = "figureTypeSelector";

    default public void applyStyleableFigureProperties(RenderContext ctx, Node node) {
        if (ctx.get((MapAccessor)RenderContext.RENDERING_INTENT) == RenderingIntent.EXPORT) {
            String styleId = this.getId();
            node.setId(styleId == null ? "" : styleId);
            node.getStyleClass().setAll((Collection)new ObservableSetFacade(this.getStyleClasses()));
            node.getProperties().put((Object)TYPE_SELECTOR_NODE_KEY, (Object)this.getTypeSelector());
        }
    }

    default public @Nullable String getStyle() {
        return (String)this.get((MapAccessor)STYLE);
    }

    default public ReadOnlySet<String> getStyleClasses() {
        return (ReadOnlySet)this.getNonNull((NonNullMapAccessor)STYLE_CLASS);
    }

    default public ReadOnlySet<String> getPseudoClassStates() {
        return (ReadOnlySet)this.getNonNull((NonNullMapAccessor)PSEUDO_CLASS);
    }

    default public @Nullable String getId() {
        return (String)this.get((MapAccessor)ID);
    }

    default public ReadOnlyProperty<String> idProperty() {
        return ID.readOnlyPropertyAt(this.getProperties());
    }
}

