/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.key.NonNullListStyleableKey;
import org.jhotdraw8.draw.key.NullablePaintableStyleableKey;
import org.jhotdraw8.draw.key.StrokeStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public interface TextStrokeableFigure
extends Figure {
    public static final CssSizeStyleableKey TEXT_STROKE_DASH_OFFSET = new CssSizeStyleableKey("text-stroke-dashoffset", CssSize.ZERO);
    public static final NonNullEnumStyleableKey<StrokeLineCap> TEXT_STROKE_LINE_CAP = new NonNullEnumStyleableKey<StrokeLineCap>("text-stroke-linecap", StrokeLineCap.class, StrokeLineCap.BUTT);
    public static final NonNullEnumStyleableKey<StrokeLineJoin> TEXT_STROKE_LINE_JOIN = new NonNullEnumStyleableKey<StrokeLineJoin>("text-stroke-linejoin", StrokeLineJoin.class, StrokeLineJoin.MITER);
    public static final CssSizeStyleableKey TEXT_STROKE_MITER_LIMIT = new CssSizeStyleableKey("text-stroke-miterlimit", CssSize.of((double)10.0));
    public static final NullablePaintableStyleableKey TEXT_STROKE = new NullablePaintableStyleableKey("text-stroke", null);
    public static final NonNullEnumStyleableKey<StrokeType> TEXT_STROKE_TYPE = new NonNullEnumStyleableKey<StrokeType>("text-stroke-type", StrokeType.class, StrokeType.OUTSIDE);
    public static final CssSizeStyleableKey TEXT_STROKE_WIDTH = new CssSizeStyleableKey("text-stroke-width", CssSize.ONE);
    public static final NonNullListStyleableKey<CssSize> TEXT_STROKE_DASH_ARRAY = new NonNullListStyleableKey("text-stroke-dasharray", (Type)((Object)CssSize.class), new SizeCssConverter(false), VectorList.of());
    public static final StrokeStyleableMapAccessor TEXT_STROKE_STYLE = new StrokeStyleableMapAccessor("text-stroke-style", (MapAccessor<StrokeType>)TEXT_STROKE_TYPE, (MapAccessor<StrokeLineCap>)TEXT_STROKE_LINE_CAP, (MapAccessor<StrokeLineJoin>)TEXT_STROKE_LINE_JOIN, (MapAccessor<CssSize>)TEXT_STROKE_MITER_LIMIT, (MapAccessor<CssSize>)TEXT_STROKE_DASH_OFFSET, (MapAccessor<ImmutableList<CssSize>>)TEXT_STROKE_DASH_ARRAY);

    default public void applyTextStrokeableFigureProperties(@Nullable RenderContext ctx, Shape shape) {
        Paint paint = Paintable.getPaint((Paintable)this.getStyled((MapAccessor)TEXT_STROKE), ctx);
        DefaultUnitConverter units = ctx == null ? DefaultUnitConverter.getInstance() : (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double strokeWidth = units.convert((CssSize)this.getStyledNonNull((NonNullMapAccessor)TEXT_STROKE_WIDTH), "");
        if (!Objects.equals(shape.getStroke(), paint)) {
            shape.setStroke(paint);
        }
        if (paint == null) {
            return;
        }
        if (shape.getStrokeWidth() != strokeWidth) {
            shape.setStrokeWidth(strokeWidth);
        }
        StrokeLineCap slp = (StrokeLineCap)this.getStyled((MapAccessor)TEXT_STROKE_LINE_CAP);
        if (shape.getStrokeLineCap() != slp) {
            shape.setStrokeLineCap(slp);
        }
        StrokeLineJoin slj = (StrokeLineJoin)this.getStyled((MapAccessor)TEXT_STROKE_LINE_JOIN);
        if (shape.getStrokeLineJoin() != slj) {
            shape.setStrokeLineJoin(slj);
        }
        double d = units.convert((CssSize)this.getStyledNonNull((NonNullMapAccessor)TEXT_STROKE_MITER_LIMIT), "");
        if (shape.getStrokeMiterLimit() != d) {
            shape.setStrokeMiterLimit(d);
        }
        StrokeType st = (StrokeType)this.getStyled((MapAccessor)TEXT_STROKE_TYPE);
        if (shape.getStrokeType() != st) {
            shape.setStrokeType(st);
        }
        this.applyTextStrokeDashProperties(shape);
    }

    default public void applyTextStrokeDashProperties(Shape shape) {
        ImmutableList dashArray;
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)TEXT_STROKE_DASH_OFFSET)).getConvertedValue();
        if (shape.getStrokeDashOffset() != d) {
            shape.setStrokeDashOffset(d);
        }
        if ((dashArray = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)TEXT_STROKE_DASH_ARRAY)).isEmpty()) {
            shape.getStrokeDashArray().clear();
        } else {
            ArrayList<Double> list = new ArrayList<Double>(dashArray.size());
            for (CssSize sz : dashArray) {
                list.add(sz.getConvertedValue());
            }
            shape.getStrokeDashArray().setAll(list);
        }
    }
}

