/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.gui;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SubScene;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

public class ZoomableScrollPane
extends GridPane {
    public static final String ZOOMABLE_SCROLL_PANE_STYLE_CLASS = "jhotdraw8-zoomable-scroll-pane";
    public static final String ZOOMABLE_SCROLL_PANE_VIEWPORT_STYLE_CLASS = "jhotdraw8-zoomable-scroll-pane-viewpprt";
    public static final String ZOOMABLE_SCROLL_PANE_BACKGROUND_STYLE_CLASS = "jhotdraw8-zoomable-scroll-pane-background";
    public static final String ZOOMABLE_SCROLL_PANE_SUBSCENE_STYLE_CLASS = "jhotdraw8-zoomable-scroll-pane-subscene";
    public static final String ZOOMABLE_SCROLL_PANE_FOREGROUND_STYLE_CLASS = "jhotdraw8-zoomable-scroll-pane-foreground";
    private final DoubleProperty zoomFactor = new SimpleDoubleProperty((Object)this, "zoomFactor", 1.0);
    private final ObjectProperty<Bounds> visibleContentRect = new SimpleObjectProperty((Object)this, "contentRect");
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private ScrollBar horizontalScrollBar;
    @FXML
    private ScrollBar verticalScrollBar;
    @FXML
    private Pane background;
    @FXML
    private SubScene subScene;
    private Pane content;
    @FXML
    private Pane foreground;
    @FXML
    private Pane viewportPane;
    private final Property<Transform> contentToView = new SimpleObjectProperty((Object)this, "contentToView");
    private ObjectProperty<ScrollPane.ScrollBarPolicy> hbarPolicy;
    private ObjectProperty<ScrollPane.ScrollBarPolicy> vbarPolicy;
    private StyleableBooleanProperty pannable;
    private static final PseudoClass PANNABLE_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"pannable");

    @FXML
    void initialize() {
        assert (this.horizontalScrollBar != null) : "fx:id=\"horizontalScrollBar\" was not injected: check your FXML file 'ZoomableScrollPane.fxml'.";
        assert (this.verticalScrollBar != null) : "fx:id=\"verticalScrollBar\" was not injected: check your FXML file 'ZoomableScrollPane.fxml'.";
        assert (this.background != null) : "fx:id=\"backgroundPane\" was not injected: check your FXML file 'ZoomableScrollPane.fxml'.";
        assert (this.subScene != null) : "fx:id=\"subScene\" was not injected: check your FXML file 'ZoomableScrollPane.fxml'.";
        assert (this.foreground != null) : "fx:id=\"foregroundPane\" was not injected: check your FXML file 'ZoomableScrollPane.fxml'.";
        assert (this.viewportPane != null) : "fx:id=\"viewportPane\" was not injected: check your FXML file 'ZoomableScrollPane.fxml'.";
        this.initStyle();
        this.initLayout();
        this.initBindings();
        this.initBehavior();
    }

    private void initStyle() {
        this.getStyleClass().add((Object)ZOOMABLE_SCROLL_PANE_STYLE_CLASS);
        this.viewportPane.getStyleClass().add((Object)ZOOMABLE_SCROLL_PANE_VIEWPORT_STYLE_CLASS);
        this.background.getStyleClass().add((Object)ZOOMABLE_SCROLL_PANE_BACKGROUND_STYLE_CLASS);
        this.foreground.getStyleClass().add((Object)ZOOMABLE_SCROLL_PANE_FOREGROUND_STYLE_CLASS);
        this.subScene.getStyleClass().add((Object)ZOOMABLE_SCROLL_PANE_SUBSCENE_STYLE_CLASS);
    }

    private void initBehavior() {
        this.horizontalScrollBar.setUnitIncrement(20.0);
        this.verticalScrollBar.setUnitIncrement(20.0);
        this.zoomFactor.addListener(this::onZoomFactorChanged);
        this.viewportPane.addEventHandler(ScrollEvent.SCROLL, event -> {
            this.onScrollEvent((ScrollEvent)event, this.horizontalScrollBar, event.getDeltaX());
            this.onScrollEvent((ScrollEvent)event, this.verticalScrollBar, event.getDeltaY());
        });
        this.viewportPane.addEventHandler(ZoomEvent.ZOOM, event -> {});
    }

    private void onZoomFactorChanged(Observable o, Number oldv, Number newv) {
        double oldvv = oldv.doubleValue();
        double newvv = newv.doubleValue();
        double sf = oldvv / newvv;
        double hmin = this.horizontalScrollBar.getMin();
        double hmax = this.horizontalScrollBar.getMax();
        double hvalue = this.horizontalScrollBar.getValue();
        double hvisible = this.horizontalScrollBar.getVisibleAmount();
        double holdmax = hmax * sf;
        double holdmin = hmin * sf;
        double vmin = this.verticalScrollBar.getMin();
        double vmax = this.verticalScrollBar.getMax();
        double vvalue = this.verticalScrollBar.getValue();
        double vvisible = this.verticalScrollBar.getVisibleAmount();
        double voldmax = vmax * sf;
        double voldmin = vmin * sf;
        double osf = 1.0 / oldvv;
        double oldx = (holdmax - hvisible) * (hvalue - holdmin) / (holdmax - holdmin) * osf;
        double oldy = (voldmax - vvisible) * (vvalue - voldmin) / (voldmax - voldmin) * osf;
        double oldw = hvisible * osf;
        double oldh = vvisible * osf;
        this.scrollContentRectToVisible(oldx, oldy, oldw, oldh);
    }

    public ReadOnlyObjectProperty<Bounds> viewportRectProperty() {
        return this.viewportPane.boundsInParentProperty();
    }

    private void initBindings() {
        DoubleBinding contentTranslateXBinding = ZoomableScrollPane.createContentRectTranslateBinding(this.horizontalScrollBar);
        DoubleBinding contentTranslateYBinding = ZoomableScrollPane.createContentRectTranslateBinding(this.verticalScrollBar);
        this.visibleContentRect.bind((ObservableValue)CustomBinding.compute(() -> {
            double invf = 1.0 / this.zoomFactor.get();
            return new BoundingBox(contentTranslateXBinding.get() * invf, contentTranslateYBinding.get() * invf, this.horizontalScrollBar.getVisibleAmount() * invf, this.verticalScrollBar.getVisibleAmount() * invf);
        }, (ObservableValue[])new ObservableValue[]{contentTranslateXBinding, contentTranslateYBinding, this.horizontalScrollBar.visibleAmountProperty(), this.verticalScrollBar.visibleAmountProperty(), this.zoomFactor, this.layoutBoundsProperty()}));
        this.subScene.widthProperty().bind((ObservableValue)this.viewportWidthProperty());
        this.subScene.heightProperty().bind((ObservableValue)this.viewportHeightProperty());
        Scale scale = new Scale();
        scale.setPivotX(0.0);
        scale.setPivotY(0.0);
        this.zoomFactor.addListener((o, oldv, newv) -> {
            scale.setX(newv.doubleValue());
            scale.setY(newv.doubleValue());
        });
        Translate translate = new Translate();
        translate.xProperty().bind((ObservableValue)contentTranslateXBinding.negate());
        translate.yProperty().bind((ObservableValue)contentTranslateYBinding.negate());
        this.content.getTransforms().addAll((Object[])new Transform[]{translate, scale});
        this.horizontalScrollBar.maxProperty().bind((ObservableValue)CustomBinding.compute(() -> this.getContentWidth() * this.getZoomFactor() + this.getInsets().getRight(), (ObservableValue[])new ObservableValue[]{this.contentWidthProperty(), this.zoomFactor, this.insetsProperty()}));
        this.horizontalScrollBar.minProperty().bind((ObservableValue)CustomBinding.compute(() -> -this.getInsets().getLeft(), (ObservableValue[])new ObservableValue[]{this.insetsProperty()}));
        this.verticalScrollBar.maxProperty().bind((ObservableValue)CustomBinding.compute(() -> this.getContentHeight() * this.getZoomFactor() + this.getInsets().getBottom(), (ObservableValue[])new ObservableValue[]{this.contentHeightProperty(), this.zoomFactor, this.insetsProperty()}));
        this.verticalScrollBar.minProperty().bind((ObservableValue)CustomBinding.compute(() -> -this.getInsets().getTop(), (ObservableValue[])new ObservableValue[]{this.insetsProperty()}));
        this.horizontalScrollBar.visibleAmountProperty().bind((ObservableValue)this.viewportWidthProperty());
        this.verticalScrollBar.visibleAmountProperty().bind((ObservableValue)this.viewportHeightProperty());
        this.horizontalScrollBar.blockIncrementProperty().bind((ObservableValue)this.viewportWidthProperty());
        this.verticalScrollBar.blockIncrementProperty().bind((ObservableValue)this.viewportHeightProperty());
        this.onlyShowHorizontalScrollBarIfNeeded(this.horizontalScrollBar, (RowConstraints)this.getRowConstraints().get(1), this.hbarPolicyProperty());
        this.onlyShowVerticalScrollBarIfNeeded(this.verticalScrollBar, (ColumnConstraints)this.getColumnConstraints().get(1), this.vbarPolicyProperty());
        this.contentToView.bind((ObservableValue)CustomBinding.compute(() -> {
            double sf = this.getZoomFactor();
            Bounds vcRect = this.getVisibleContentRect();
            double x = vcRect.getMinX();
            double y = vcRect.getMinY();
            return new Affine(sf, 0.0, -x * sf, 0.0, sf, -y * sf);
        }, (ObservableValue[])new ObservableValue[]{this.visibleContentRect}));
    }

    private void onlyShowHorizontalScrollBarIfNeeded(ScrollBar scrollBar, RowConstraints rowConstraints, ObjectProperty<ScrollPane.ScrollBarPolicy> scrollBarPolicy) {
        BooleanBinding visibilityBinding = Bindings.createBooleanBinding(() -> {
            if (scrollBarPolicy.get() == ScrollPane.ScrollBarPolicy.NEVER) {
                return false;
            }
            if (scrollBarPolicy.get() == ScrollPane.ScrollBarPolicy.ALWAYS) {
                return true;
            }
            return this.contentWidthProperty().get() > this.getWidth() || this.contentHeightProperty().get() > this.getHeight() && this.contentWidthProperty().get() > this.getWidth() - this.verticalScrollBar.getWidth();
        }, (Observable[])new Observable[]{scrollBarPolicy, this.contentHeightProperty(), this.contentWidthProperty(), this.heightProperty(), this.widthProperty(), this.verticalScrollBar.prefWidthProperty()});
        scrollBar.visibleProperty().bind((ObservableValue)visibilityBinding);
        rowConstraints.prefHeightProperty().bind((ObservableValue)CustomBinding.convert((ObservableValue)visibilityBinding, b -> b != false ? -1.0 : 0.0));
    }

    private void onlyShowVerticalScrollBarIfNeeded(ScrollBar scrollBar, ColumnConstraints colConstraints, ObjectProperty<ScrollPane.ScrollBarPolicy> scrollBarPolicy) {
        BooleanBinding visibilityBinding = Bindings.createBooleanBinding(() -> {
            if (scrollBarPolicy.get() == ScrollPane.ScrollBarPolicy.NEVER) {
                return false;
            }
            if (scrollBarPolicy.get() == ScrollPane.ScrollBarPolicy.ALWAYS) {
                return true;
            }
            return this.contentHeightProperty().get() > this.getHeight() || this.contentWidthProperty().get() > this.getWidth() && this.contentHeightProperty().get() > this.getHeight() - this.horizontalScrollBar.getHeight();
        }, (Observable[])new Observable[]{scrollBarPolicy, this.contentHeightProperty(), this.contentWidthProperty(), this.heightProperty(), this.widthProperty(), this.verticalScrollBar.prefWidthProperty()});
        scrollBar.visibleProperty().bind((ObservableValue)visibilityBinding);
        colConstraints.prefWidthProperty().bind((ObservableValue)CustomBinding.convert((ObservableValue)visibilityBinding, b -> b != false ? -1.0 : 0.0));
    }

    private void initLayout() {
        this.content = new Pane();
        this.content.setManaged(false);
        this.subScene.setRoot((Parent)this.content);
        Rectangle clipRect = new Rectangle();
        clipRect.widthProperty().bind((ObservableValue)this.viewportWidthProperty());
        clipRect.heightProperty().bind((ObservableValue)this.viewportHeightProperty());
        this.viewportPane.setClip((Node)clipRect);
        this.viewportPane.setBackground(null);
        this.background.setBackground(null);
        this.foreground.setBackground(null);
        this.content.setBackground(null);
        this.content.getStyleClass().clear();
    }

    private void onScrollEvent(ScrollEvent event, ScrollBar scrollBar, double delta) {
        double min = scrollBar.getMin();
        double max = scrollBar.getMax();
        double value = scrollBar.getValue();
        double visible = scrollBar.getVisibleAmount();
        if (visible < max - min) {
            scrollBar.setValue(MathUtil.clamp((double)(value - delta), (double)min, (double)max));
            event.consume();
        }
    }

    private static DoubleBinding createContentRectTranslateBinding(ScrollBar scrollBar) {
        return CustomBinding.computeDouble(() -> ZoomableScrollPane.getScrollBarPosition(scrollBar), (ObservableValue[])new ObservableValue[]{scrollBar.valueProperty(), scrollBar.minProperty(), scrollBar.maxProperty(), scrollBar.visibleAmountProperty()});
    }

    public static @Nullable URL getFxmlResource() {
        return ZoomableScrollPane.class.getResource("/org/jhotdraw8/draw/gui/ZoomableScrollPane.fxml");
    }

    public final ReadOnlyDoubleProperty viewportWidthProperty() {
        return this.viewportPane.widthProperty();
    }

    public final ReadOnlyDoubleProperty viewportHeightProperty() {
        return this.viewportPane.heightProperty();
    }

    public final DoubleProperty zoomFactorProperty() {
        return this.zoomFactor;
    }

    public double getZoomFactor() {
        return this.zoomFactor.get();
    }

    public final ReadOnlyDoubleProperty viewWidthProperty() {
        return this.horizontalScrollBar.maxProperty();
    }

    public final ReadOnlyDoubleProperty viewHeightProperty() {
        return this.verticalScrollBar.maxProperty();
    }

    public double getViewportWidth() {
        return this.viewportWidthProperty().getValue();
    }

    public double getViewportHeight() {
        return this.viewportHeightProperty().getValue();
    }

    public ObservableList<Node> getContentChildren() {
        return this.content.getChildren();
    }

    public ObservableList<Node> getBackgroundChildren() {
        return this.background.getChildren();
    }

    public ObservableList<Node> getForegroundChildren() {
        return this.foreground.getChildren();
    }

    public Bounds getVisibleContentRect() {
        return (Bounds)this.visibleContentRect.get();
    }

    public Bounds getViewRect() {
        return this.getContentToView().transform(this.getVisibleContentRect());
    }

    private static double getScrollBarPosition(ScrollBar sb) {
        double value = sb.getValue();
        double min = sb.getMin();
        double max = sb.getMax();
        double visible = sb.getVisibleAmount();
        if (visible > max) {
            return -Math.round((visible - max) * 0.5);
        }
        return MathUtil.clamp((double)((double)Math.round((max - min - visible) * (value - min) / (max - min)) + min), (double)min, (double)max);
    }

    public Bounds getViewportRect() {
        return this.viewportPane.getBoundsInParent();
    }

    public ReadOnlyObjectProperty<Bounds> visibleContentRectProperty() {
        return this.visibleContentRect;
    }

    public void setZoomFactor(double newValue) {
        this.zoomFactor.set(newValue);
    }

    public final Bounds getViewportBounds() {
        return this.viewportPane.getLayoutBounds();
    }

    public void scrollViewRectToVisible(Bounds b) {
        this.scrollContentRectToVisible(this.getViewToContent().transform(b));
    }

    public void scrollViewRectToVisible(double x, double y, double w, double h) {
        this.scrollViewRectToVisible((Bounds)new BoundingBox(x, y, w, h));
    }

    public void scrollContentRectToVisible(double x, double y, double w, double h) {
        double sf = this.getZoomFactor();
        double hmin = this.horizontalScrollBar.getMin();
        double hmax = this.horizontalScrollBar.getMax();
        double hvisible = this.horizontalScrollBar.getVisibleAmount();
        double vmin = this.verticalScrollBar.getMin();
        double vmax = this.verticalScrollBar.getMax();
        double vvisible = this.verticalScrollBar.getVisibleAmount();
        double cx = x * sf + (w * sf - hvisible) * 0.5;
        double cy = y * sf + (h * sf - vvisible) * 0.5;
        double hvalue = cx * (hmax - hmin) / (hmax - hvisible) + hmin;
        double vvalue = cy * (vmax - vmin) / (vmax - vvisible) + vmin;
        this.horizontalScrollBar.setValue(MathUtil.clamp((double)hvalue, (double)this.horizontalScrollBar.getMin(), (double)this.horizontalScrollBar.getMax()));
        this.verticalScrollBar.setValue(MathUtil.clamp((double)vvalue, (double)this.verticalScrollBar.getMin(), (double)this.verticalScrollBar.getMax()));
    }

    public void scrollContentRectToVisible(Bounds boundsInWorld) {
        this.scrollContentRectToVisible(boundsInWorld.getMinX(), boundsInWorld.getMinY(), boundsInWorld.getWidth(), boundsInWorld.getHeight());
    }

    public Transform getContentToView() {
        return (Transform)this.contentToViewProperty().getValue();
    }

    public Transform getViewToContent() {
        try {
            return this.getContentToView().createInverse();
        }
        catch (NonInvertibleTransformException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
            return FXTransforms.IDENTITY;
        }
    }

    public ReadOnlyProperty<Transform> contentToViewProperty() {
        return this.contentToView;
    }

    public DoubleProperty contentWidthProperty() {
        return this.content.prefWidthProperty();
    }

    public DoubleProperty contentHeightProperty() {
        return this.content.prefHeightProperty();
    }

    public void setContentSize(double w, double h) {
        this.setContentWidth(w);
        this.setContentHeight(h);
    }

    public void setContentWidth(double w) {
        this.contentWidthProperty().set(w);
    }

    public void setContentHeight(double w) {
        this.contentHeightProperty().set(w);
    }

    public double getContentWidth() {
        return this.contentWidthProperty().get();
    }

    public double getContentHeight() {
        return this.contentHeightProperty().get();
    }

    public String getSubSceneUserAgentStylesheet() {
        return this.subScene.getUserAgentStylesheet();
    }

    public void setSubSceneUserAgentStylesheet(String newValue) {
        this.subScene.setUserAgentStylesheet(newValue);
    }

    public ObjectProperty<String> subSceneUserAgentStylesheetProperty() {
        return this.subScene.userAgentStylesheetProperty();
    }

    public Node getNode() {
        return this;
    }

    public static ZoomableScrollPane create() {
        FXMLLoader loader = new FXMLLoader();
        ZoomableScrollPane controller = new ZoomableScrollPane();
        loader.setLocation(ZoomableScrollPane.getFxmlResource());
        loader.setResources(null);
        loader.setController((Object)controller);
        loader.setRoot((Object)controller);
        try {
            loader.load();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (ZoomableScrollPane)((Object)loader.getController());
    }

    public ReadOnlyDoubleProperty viewRectWidthProperty() {
        return this.horizontalScrollBar.visibleAmountProperty();
    }

    public ReadOnlyDoubleProperty viewRectHeightProperty() {
        return this.verticalScrollBar.visibleAmountProperty();
    }

    public final void setHbarPolicy(ScrollPane.ScrollBarPolicy value) {
        this.hbarPolicyProperty().set((Object)value);
    }

    public final ScrollPane.ScrollBarPolicy getHbarPolicy() {
        return this.hbarPolicy == null ? ScrollPane.ScrollBarPolicy.AS_NEEDED : (ScrollPane.ScrollBarPolicy)this.hbarPolicy.get();
    }

    public final ObjectProperty<ScrollPane.ScrollBarPolicy> hbarPolicyProperty() {
        if (this.hbarPolicy == null) {
            this.hbarPolicy = new StyleableObjectProperty<ScrollPane.ScrollBarPolicy>(ScrollPane.ScrollBarPolicy.AS_NEEDED){

                public CssMetaData<ZoomableScrollPane, ScrollPane.ScrollBarPolicy> getCssMetaData() {
                    return StyleableProperties.HBAR_POLICY;
                }

                public Object getBean() {
                    return ZoomableScrollPane.this;
                }

                public String getName() {
                    return "hbarPolicy";
                }
            };
        }
        return this.hbarPolicy;
    }

    public final void setVbarPolicy(ScrollPane.ScrollBarPolicy value) {
        this.vbarPolicyProperty().set((Object)value);
    }

    public final ScrollPane.ScrollBarPolicy getVbarPolicy() {
        return this.vbarPolicy == null ? ScrollPane.ScrollBarPolicy.AS_NEEDED : (ScrollPane.ScrollBarPolicy)this.vbarPolicy.get();
    }

    public final ObjectProperty<ScrollPane.ScrollBarPolicy> vbarPolicyProperty() {
        if (this.vbarPolicy == null) {
            this.vbarPolicy = new StyleableObjectProperty<ScrollPane.ScrollBarPolicy>(ScrollPane.ScrollBarPolicy.AS_NEEDED){

                public CssMetaData<ZoomableScrollPane, ScrollPane.ScrollBarPolicy> getCssMetaData() {
                    return StyleableProperties.VBAR_POLICY;
                }

                public Object getBean() {
                    return ZoomableScrollPane.this;
                }

                public String getName() {
                    return "vbarPolicy";
                }
            };
        }
        return this.vbarPolicy;
    }

    public final void setPannable(boolean value) {
        this.pannableProperty().set(value);
    }

    public final boolean isPannable() {
        return this.pannable != null && this.pannable.get();
    }

    public final StyleableBooleanProperty pannableProperty() {
        if (this.pannable == null) {
            this.pannable = new StyleableBooleanProperty(false){

                public void invalidated() {
                    ZoomableScrollPane.this.pseudoClassStateChanged(PANNABLE_PSEUDOCLASS_STATE, this.get());
                }

                public CssMetaData<ZoomableScrollPane, Boolean> getCssMetaData() {
                    return StyleableProperties.PANNABLE;
                }

                public Object getBean() {
                    return ZoomableScrollPane.this;
                }

                public String getName() {
                    return "pannable";
                }
            };
        }
        return this.pannable;
    }

    private static class StyleableProperties {
        private static final CssMetaData<ZoomableScrollPane, ScrollPane.ScrollBarPolicy> HBAR_POLICY = new CssMetaData<ZoomableScrollPane, ScrollPane.ScrollBarPolicy>("-fx-hbar-policy", StyleConverter.getEnumConverter(ScrollPane.ScrollBarPolicy.class), ScrollPane.ScrollBarPolicy.AS_NEEDED){

            public boolean isSettable(ZoomableScrollPane n) {
                return n.hbarPolicy == null || !n.hbarPolicy.isBound();
            }

            public StyleableProperty<ScrollPane.ScrollBarPolicy> getStyleableProperty(ZoomableScrollPane n) {
                return (StyleableProperty)n.hbarPolicyProperty();
            }
        };
        private static final CssMetaData<ZoomableScrollPane, ScrollPane.ScrollBarPolicy> VBAR_POLICY = new CssMetaData<ZoomableScrollPane, ScrollPane.ScrollBarPolicy>("-fx-vbar-policy", StyleConverter.getEnumConverter(ScrollPane.ScrollBarPolicy.class), ScrollPane.ScrollBarPolicy.AS_NEEDED){

            public boolean isSettable(ZoomableScrollPane n) {
                return n.vbarPolicy == null || !n.vbarPolicy.isBound();
            }

            public StyleableProperty<ScrollPane.ScrollBarPolicy> getStyleableProperty(ZoomableScrollPane n) {
                return (StyleableProperty)n.vbarPolicyProperty();
            }
        };
        private static final CssMetaData<ZoomableScrollPane, Boolean> PANNABLE = new CssMetaData<ZoomableScrollPane, Boolean>("-fx-pannable", StyleConverter.getBooleanConverter(), Boolean.FALSE){

            public boolean isSettable(ZoomableScrollPane n) {
                return n.pannable == null || !n.pannable.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(ZoomableScrollPane n) {
                return n.pannableProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(Control.getClassCssMetaData());
            styleables.add(HBAR_POLICY);
            styleables.add(VBAR_POLICY);
            styleables.add(PANNABLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

