/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.function.Function;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.LocatorHandle;
import org.jhotdraw8.draw.locator.Locator;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

abstract class AbstractResizeTransformHandle
extends LocatorHandle {
    public static final @Nullable BorderStrokeStyle INSIDE_STROKE = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 1.0, 0.0, null);
    private final Region node = new Region();
    private Point2D oldPoint;
    private Point2D pickLocation;
    protected double preferredAspectRatio;
    protected CssRectangle2D startBounds;
    private @Nullable Transform startWorldToLocal;
    private final Function<Color, Border> borderFactory;

    public AbstractResizeTransformHandle(Figure owner, Locator locator, Shape shape, @Nullable Background bg, Function<Color, Border> borderFactory) {
        super(owner, locator);
        this.node.setShape(shape);
        this.node.setManaged(false);
        this.node.setScaleShape(true);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
        this.borderFactory = borderFactory;
        this.node.setBackground(bg);
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public Region getNode(DrawingView view) {
        double size = view.getEditor().getHandleSize();
        if (this.node.getWidth() != size) {
            this.node.resize(size, size);
        }
        CssColor color = view.getEditor().getHandleColor();
        this.node.setBorder(this.borderFactory.apply(color.getColor()));
        return this.node;
    }

    @Override
    public void onMouseDragged(MouseEvent event, DrawingView view) {
        CssPoint2D newPoint = new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY())));
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(this.owner, newPoint);
        }
        if (event.isMetaDown()) {
            Point2D loc;
            this.oldPoint = loc = this.getLocation();
        }
        boolean keepAspect = event.isShiftDown();
        Transform t = this.startWorldToLocal;
        if (t == null || t.isIdentity()) {
            this.resize(newPoint, this.owner, this.startBounds, view.getModel(), keepAspect);
        } else {
            this.resize(this.convertPoint2D(new CssPoint2D(FXTransforms.transform((Transform)t, (Point2D)newPoint.getConvertedValue())), newPoint.getX().getUnits(), (UnitConverter)DefaultUnitConverter.getInstance()), this.owner, this.startBounds, view.getModel(), keepAspect);
        }
    }

    @Override
    public void onMousePressed(MouseEvent event, DrawingView view) {
        this.oldPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY())))).getConvertedValue();
        this.startBounds = this.owner.getCssLayoutBounds();
        this.startWorldToLocal = this.owner.getWorldToLocal();
        this.preferredAspectRatio = this.owner.getPreferredAspectRatio();
    }

    @Override
    public void onMouseReleased(MouseEvent event, DrawingView dv) {
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    protected void resize(Point2D newPoint, Figure owner, Bounds bounds, DrawingModel model, boolean keepAspect) {
        throw new UnsupportedOperationException("don't want to implement this in class " + String.valueOf(this.getClass()));
    }

    protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
        this.resize(newPoint.getConvertedValue(), owner, bounds.getConvertedBoundsValue(), model, keepAspect);
    }

    @Override
    public void updateNode(DrawingView view) {
        Figure f = this.owner;
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Bounds b = f.getLayoutBounds();
        Point2D p = this.getLocation();
        this.pickLocation = p = FXTransforms.transform((Transform)t, (Point2D)p);
        double size = this.node.getWidth();
        this.node.relocate(p.getX() - size * 0.5, p.getY() - size * 0.5);
        this.node.setRotate(((Double)f.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.node.setRotationAxis((Point3D)f.getStyled((MapAccessor)TransformableFigure.ROTATION_AXIS));
    }

    private CssPoint2D convertPoint2D(CssPoint2D cssPoint2D, String units, UnitConverter c) {
        return new CssPoint2D(c.convertSize(cssPoint2D.getX(), units), c.convertSize(cssPoint2D.getY(), units));
    }
}

