/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.event.ActionEvent;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractBezierNodeHandleAction;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierNodeHandleOutgoingTangentAction
extends AbstractBezierNodeHandleAction {
    public static final String ID = "handle.bezierNode.outgoingTangent";

    public BezierNodeHandleOutgoingTangentAction(Figure figure, MapAccessor<BezierPath> pathKey, int nodeIndex, DrawingView view) {
        super(ID, figure, pathKey, nodeIndex, view);
        BezierPath path = (BezierPath)figure.get(pathKey);
        if (path != null && path.size() > nodeIndex) {
            BezierNode bnode = path.get(nodeIndex);
            this.setSelected((bnode.getMask() & 6) == 4);
        }
    }

    protected void onActionPerformed(ActionEvent event) {
        BezierPath path = (BezierPath)this.owner.get(this.pathKey);
        if (path == null || path.size() <= this.nodeIndex) {
            return;
        }
        BezierNode bnode = path.get(this.nodeIndex);
        BezierNode changedNode = bnode.withMaskBitsClears(6).withMaskBitsSet(4);
        path = path.set(this.nodeIndex, changedNode);
        this.view.getModel().set(this.owner, this.pathKey, path);
        this.view.recreateHandles();
    }
}

