/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.action.Actions;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.draw.handle.BezierNodeHandleIncomingAndOutgoingTangentAction;
import org.jhotdraw8.draw.handle.BezierNodeHandleIncomingTangentAction;
import org.jhotdraw8.draw.handle.BezierNodeHandleNoTangentsAction;
import org.jhotdraw8.draw.handle.BezierNodeHandleOutgoingTangentAction;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;
import org.jspecify.annotations.Nullable;

public class BezierNodeNonMovableEditHandle
extends AbstractHandle {
    private static final @Nullable Background REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
    private static final @Nullable Border REGION_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.SOLID, null, null)});
    private static final Circle REGION_SHAPE_CUBIC = new Circle(0.0, 0.0, 4.0);
    private static final Rectangle REGION_SHAPE_LINEAR = new Rectangle(7.0, 7.0);
    private static final Path REGION_SHAPE_QUADRATIC = new Path();
    private final Region node;
    private @Nullable Point2D pickLocation;
    private final int nodeIndex;
    private final MapAccessor<BezierPath> pathKey;

    public BezierNodeNonMovableEditHandle(Figure figure, MapAccessor<BezierPath> pathKey, int nodeIndex) {
        super(figure);
        this.pathKey = pathKey;
        this.nodeIndex = nodeIndex;
        this.node = new Region();
        this.node.setShape((Shape)REGION_SHAPE_LINEAR);
        this.node.setManaged(false);
        this.node.setScaleShape(true);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
        this.node.setBorder(REGION_BORDER);
        this.node.setBackground(REGION_BACKGROUND);
    }

    @Override
    public boolean contains(DrawingView drawingView, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    private @Nullable BezierNode getBezierNode() {
        BezierPath path = (BezierPath)this.owner.get(this.pathKey);
        return path == null || path.size() <= this.nodeIndex ? null : path.get(this.nodeIndex);
    }

    @Override
    public Cursor getCursor() {
        return Cursor.CROSSHAIR;
    }

    private Point2D getLocation() {
        return (Point2D)this.getBezierNode().getPoint(Point2D::new);
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public Region getNode(DrawingView view) {
        double size = view.getEditor().getHandleSize();
        if (this.node.getWidth() != size) {
            this.node.resize(size, size);
        }
        CssColor color = view.getEditor().getHandleColor();
        BorderStroke borderStroke = (BorderStroke)this.node.getBorder().getStrokes().getFirst();
        if (!borderStroke.getTopStroke().equals(color.getColor())) {
            this.node.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)color.getColor(), BorderStrokeStyle.SOLID, null, null)}));
        }
        return this.node;
    }

    @Override
    public void onMouseClicked(MouseEvent event, DrawingView dv) {
    }

    @Override
    public void onMousePressed(MouseEvent event, DrawingView view) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, view);
        }
    }

    private void onPopupTriggered(MouseEvent event, DrawingView view) {
        RadioMenuItem bothRadio;
        RadioMenuItem outRadio;
        RadioMenuItem inRadio;
        ContextMenu contextMenu = new ContextMenu();
        Menu pathMenu = new Menu(DrawLabels.getResources().getString("handle.bezierNode.path.text"));
        RadioMenuItem moveToRadio = new RadioMenuItem(DrawLabels.getResources().getString("handle.bezierNode.moveTo.text"));
        RadioMenuItem lineToRadio = new RadioMenuItem(DrawLabels.getResources().getString("handle.bezierNode.lineTo.text"));
        BezierPath path = (BezierPath)this.owner.get(this.pathKey);
        if (path == null || this.nodeIndex >= path.size()) {
            return;
        }
        BezierPath[] finalPath = new BezierPath[]{path};
        BezierNode bnode = finalPath[0].get(this.nodeIndex);
        if (this.nodeIndex == 0 || bnode.isMoveTo()) {
            moveToRadio.setSelected(true);
        } else {
            lineToRadio.setSelected(true);
        }
        moveToRadio.setOnAction(actionEvent -> {
            BezierNode changedNode = bnode.withMaskBitsClears(16).withMaskBitsSet(8);
            finalPath[0] = finalPath[0].set(this.nodeIndex, changedNode);
            view.getModel().set(this.owner, this.pathKey, finalPath[0]);
            view.recreateHandles();
        });
        lineToRadio.setOnAction(actionEvent -> {
            BezierNode changedNode = bnode.withMaskBitsClears(24);
            finalPath[0] = finalPath[0].set(this.nodeIndex, changedNode);
            view.getModel().set(this.owner, this.pathKey, finalPath[0]);
            view.recreateHandles();
        });
        pathMenu.getItems().addAll((Object[])new MenuItem[]{moveToRadio, lineToRadio});
        Menu tangentsMenu = new Menu(DrawLabels.getResources().getString("handle.bezierNode.tangents.text"));
        RadioMenuItem noneRadio = new RadioMenuItem();
        Actions.bindMenuItem((MenuItem)noneRadio, (Action)new BezierNodeHandleNoTangentsAction(this.owner, this.pathKey, this.nodeIndex, view));
        if (this.nodeIndex > 0) {
            inRadio = new RadioMenuItem();
            Actions.bindMenuItem((MenuItem)inRadio, (Action)new BezierNodeHandleIncomingTangentAction(this.owner, this.pathKey, this.nodeIndex, view));
        } else {
            inRadio = null;
        }
        int nodeListSize = path.size();
        if (this.nodeIndex < nodeListSize - 1) {
            outRadio = new RadioMenuItem();
            Actions.bindMenuItem((MenuItem)outRadio, (Action)new BezierNodeHandleOutgoingTangentAction(this.owner, this.pathKey, this.nodeIndex, view));
        } else {
            outRadio = null;
        }
        if (this.nodeIndex > 0 && this.nodeIndex < nodeListSize - 1) {
            bothRadio = new RadioMenuItem();
            Actions.bindMenuItem((MenuItem)bothRadio, (Action)new BezierNodeHandleIncomingAndOutgoingTangentAction(this.owner, this.pathKey, this.nodeIndex, view));
        } else {
            bothRadio = null;
        }
        tangentsMenu.getItems().add((Object)noneRadio);
        if (inRadio != null) {
            tangentsMenu.getItems().add((Object)inRadio);
        }
        if (outRadio != null) {
            tangentsMenu.getItems().add((Object)outRadio);
        }
        if (bothRadio != null) {
            tangentsMenu.getItems().add((Object)bothRadio);
        }
        contextMenu.getItems().add((Object)tangentsMenu);
        contextMenu.getItems().add((Object)pathMenu);
        contextMenu.show((Node)this.node, event.getScreenX(), event.getScreenY());
        event.consume();
    }

    @Override
    public void onMouseReleased(MouseEvent event, DrawingView view) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, view);
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void updateNode(DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        BezierPath path = (BezierPath)f.get(this.pathKey);
        if (path == null || this.nodeIndex >= path.size()) {
            this.node.setVisible(false);
            return;
        }
        this.node.setVisible(true);
        Point2D c0 = this.getLocation();
        this.pickLocation = c0 = FXTransforms.transform((Transform)t, (Point2D)c0);
        double size = this.node.getWidth();
        this.node.relocate(c0.getX() - size * 0.5, c0.getY() - size * 0.5);
        this.node.setRotate(((Double)f.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.node.setRotationAxis((Point3D)f.getStyled((MapAccessor)TransformableFigure.ROTATION_AXIS));
        BezierNode bn = this.getBezierNode();
        if (bn.hasIn() && bn.hasOut()) {
            this.node.setShape((Shape)REGION_SHAPE_CUBIC);
        } else if (bn.hasIn() || bn.hasOut()) {
            this.node.setShape((Shape)REGION_SHAPE_QUADRATIC);
        } else {
            this.node.setShape((Shape)REGION_SHAPE_LINEAR);
        }
    }

    static {
        ObservableList elements = REGION_SHAPE_QUADRATIC.getElements();
        elements.add((Object)new MoveTo(2.0, 0.0));
        elements.add((Object)new LineTo(4.0, 0.0));
        elements.add((Object)new LineTo(6.0, 2.0));
        elements.add((Object)new LineTo(6.0, 4.0));
        elements.add((Object)new LineTo(4.0, 6.0));
        elements.add((Object)new LineTo(2.0, 6.0));
        elements.add((Object)new LineTo(0.0, 4.0));
        elements.add((Object)new LineTo(0.0, 2.0));
        elements.add((Object)new ClosePath());
        elements.add((Object)new MoveTo(3.0, 0.0));
        elements.add((Object)new LineTo(3.0, 6.0));
    }
}

