/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polyline;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;
import org.jspecify.annotations.Nullable;

public class BezierNodeTangentHandle
extends AbstractHandle {
    private static final @Nullable Background REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, null, null)});
    private static final @Nullable Border REGION_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.DASHED, null, null)});
    private final Polyline node;
    private Point2D pickLocation;
    private final int pointIndex;
    private final MapAccessor<BezierPath> pathKey;

    public BezierNodeTangentHandle(Figure figure, MapAccessor<BezierPath> pathKey, int pointIndex) {
        super(figure);
        this.pathKey = pathKey;
        this.pointIndex = pointIndex;
        this.node = new Polyline();
        this.node.setManaged(false);
    }

    @Override
    public boolean contains(DrawingView drawingView, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    private BezierNode getBezierNode() {
        BezierPath list = (BezierPath)this.owner.get(this.pathKey);
        return list.get(this.pointIndex);
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    private Point2D getLocation() {
        return (Point2D)this.getBezierNode().getPoint(Point2D::new);
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public Polyline getNode(DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.node.setStroke((Paint)color.getColor());
        return this.node;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void updateNode(DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        BezierPath list = (BezierPath)f.get(this.pathKey);
        if (list == null || this.pointIndex >= list.size()) {
            this.node.setVisible(false);
            return;
        }
        this.node.setVisible(true);
        BezierNode bn = this.getBezierNode();
        Point2D c0 = FXTransforms.transform((Transform)t, (double)bn.pointX(), (double)bn.pointY());
        Point2D c1 = FXTransforms.transform((Transform)t, (double)bn.inX(), (double)bn.inY());
        Point2D c2 = FXTransforms.transform((Transform)t, (double)bn.outX(), (double)bn.outY());
        Polyline node = this.getNode(view);
        ObservableList points = node.getPoints();
        points.clear();
        if (bn.hasIn()) {
            points.add(c1.getX());
            points.add(c1.getY());
            points.add(c0.getX());
            points.add(c0.getY());
        }
        if (bn.hasOut()) {
            if (points.isEmpty()) {
                points.add(c0.getX());
                points.add(c0.getY());
            }
            points.add(c2.getX());
            points.add(c2.getY());
        }
    }
}

