/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

public class BoundsInTranslationOutlineHandle
extends AbstractHandle {
    private final Group node = new Group();
    private final Polygon poly1;
    private final Polygon poly2;
    private final double[] points = new double[8];

    public BoundsInTranslationOutlineHandle(Figure figure) {
        super(figure);
        this.poly1 = new Polygon(this.points);
        this.poly2 = new Polygon(this.points);
        this.poly1.setFill(null);
        this.poly2.setFill(null);
        this.poly1.setStrokeLineCap(StrokeLineCap.BUTT);
        this.poly2.setStrokeLineCap(StrokeLineCap.BUTT);
        this.poly1.setStrokeWidth(3.0);
        this.poly1.setStroke((Paint)Color.WHITE);
        this.node.getChildren().addAll((Object[])new Node[]{this.poly1, this.poly2});
        this.poly2.getStrokeDashArray().setAll((Object[])new Double[]{3.0});
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        return false;
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public Node getNode(DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.poly2.setStroke(Paintable.getPaint(color));
        double handleStrokeWidth = view.getEditor().getHandleStrokeWidth();
        this.poly2.setStrokeWidth(handleStrokeWidth);
        return this.node;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void updateNode(DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getParentToWorld()});
        if (f instanceof TransformableFigure) {
            TransformableFigure tf = (TransformableFigure)f;
            t = FXTransforms.concat((Transform[])new Transform[]{t, new Translate(((Double)tf.getNonNull((NonNullMapAccessor)TransformableFigure.TRANSLATE_X)).doubleValue(), ((Double)tf.getNonNull((NonNullMapAccessor)TransformableFigure.TRANSLATE_Y)).doubleValue())});
        }
        t = FXTransforms.concat((Transform[])new Transform[]{Transform.translate((double)0.5, (double)0.5), t});
        Bounds b = f.getLayoutBounds();
        this.points[0] = b.getMinX();
        this.points[1] = b.getMinY();
        this.points[2] = b.getMaxX();
        this.points[3] = b.getMinY();
        this.points[4] = b.getMaxX();
        this.points[5] = b.getMaxY();
        this.points[6] = b.getMinX();
        this.points[7] = b.getMaxY();
        if (t.isType2D()) {
            FXTransforms.transform2DPoints((Transform)t, (double[])this.points, (int)0, (double[])this.points, (int)0, (int)4);
        }
        ObservableList pp1 = this.poly1.getPoints();
        ObservableList pp2 = this.poly2.getPoints();
        for (int i = 0; i < this.points.length; ++i) {
            pp1.set(i, (Object)this.points[i]);
            pp2.set(i, (Object)this.points[i]);
        }
    }
}

