/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.function.Function;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.ConnectingFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractConnectorHandle;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jspecify.annotations.Nullable;

public class LabelConnectorHandle
extends AbstractConnectorHandle {
    protected Background regionBackgroundConnected = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, null, null)});
    protected final Background REGION_BACKGROUND_DISCONNECTED = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
    private static final Function<Color, Border> REGION_BORDER = color -> new Border(new BorderStroke[]{new BorderStroke((Paint)Color.WHITE, BorderStrokeStyle.SOLID, null, new BorderWidths(2.0)), new BorderStroke((Paint)color, BorderStrokeStyle.SOLID, null, null)});
    protected static final Circle REGION_SHAPE = new Circle(4.0);
    protected final Group groupNode;
    protected final Region targetNode;
    protected final Line lineNode;
    protected final NonNullMapAccessor<CssPoint2D> originKey;
    protected @Nullable Point2D connectorDerivative;

    public LabelConnectorHandle(ConnectingFigure figure, NonNullMapAccessor<CssPoint2D> originKey, NonNullMapAccessor<CssPoint2D> pointKey, MapAccessor<Connector> connectorKey, MapAccessor<Figure> targetKey) {
        super(figure, pointKey, connectorKey, targetKey);
        this.originKey = originKey;
        this.lineNode = new Line();
        this.lineNode.setMouseTransparent(true);
        this.lineNode.setManaged(false);
        this.targetNode = new Region();
        this.targetNode.setShape((Shape)REGION_SHAPE);
        this.targetNode.setMouseTransparent(true);
        this.targetNode.setManaged(false);
        this.targetNode.setScaleShape(true);
        this.targetNode.setCenterShape(true);
        this.targetNode.resize(10.0, 10.0);
        this.targetNode.setManaged(false);
        this.groupNode = new Group();
        this.groupNode.setManaged(false);
        this.groupNode.getChildren().addAll((Object[])new Node[]{this.lineNode, this.targetNode});
    }

    public Group getNode(DrawingView view) {
        double size = view.getEditor().getHandleSize();
        if (this.targetNode.getWidth() != size) {
            this.targetNode.resize(size, size);
        }
        CssColor color = view.getEditor().getHandleColor();
        Color color1 = (Color)Paintable.getPaint(color);
        this.targetNode.setBorder(REGION_BORDER.apply(color.getColor()));
        this.regionBackgroundConnected = new Background(new BackgroundFill[]{new BackgroundFill((Paint)color1, null, null)});
        this.lineNode.setStroke((Paint)color.getColor());
        this.updateNode(view);
        return this.groupNode;
    }

    @Override
    public void updateNode(DrawingView view) {
        ConnectingFigure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Point2D p = ((CssPoint2D)f.getNonNull(this.pointKey)).getConvertedValue();
        this.pickLocation = p = FXTransforms.transform((Transform)t, (Point2D)p);
        Connector connector = (Connector)f.get(this.connectorKey);
        Figure target = (Figure)f.get(this.targetKey);
        boolean isConnected = connector != null && target != null;
        this.targetNode.setBackground(isConnected ? this.regionBackgroundConnected : this.REGION_BACKGROUND_DISCONNECTED);
        double size = this.targetNode.getWidth();
        double a = this.connectorDerivative == null ? 0.0 : Angles.atan2((double)this.connectorDerivative.getY(), (double)this.connectorDerivative.getX());
        this.targetNode.setRotate(a * 180.0 / Math.PI);
        Point2D origin = FXTransforms.transform((Transform)t, (Point2D)((CssPoint2D)f.getNonNull(this.originKey)).getConvertedValue());
        this.lineNode.setStartX(origin.getX());
        this.lineNode.setStartY(origin.getY());
        if (isConnected) {
            PointAndDerivative pointAndDerivative = connector.getPointAndDerivativeInWorld(this.owner, target);
            this.connectorLocation = view.worldToView((Point2D)pointAndDerivative.getPoint(Point2D::new));
            this.connectorDerivative = view.getWorldToView().deltaTransform((Point2D)pointAndDerivative.getDerivative(Point2D::new));
            if (this.connectorLocation != null) {
                this.targetNode.relocate(this.connectorLocation.getX() - size * 0.5, this.connectorLocation.getY() - size * 0.5);
                this.lineNode.setEndX(this.connectorLocation.getX());
                this.lineNode.setEndY(this.connectorLocation.getY());
            }
        } else {
            this.targetNode.relocate(p.getX() - size * 0.5, p.getY() - size * 0.5);
            this.lineNode.setEndX(p.getX());
            this.lineNode.setEndY(p.getY());
        }
    }
}

