/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.function.Function;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.ConnectingFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractConnectorHandle;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

public class LineConnectorHandle
extends AbstractConnectorHandle {
    public static final @Nullable BorderStrokeStyle INSIDE_STROKE = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 1.0, 0.0, null);
    private Background REGION_BACKGROUND_CONNECTED = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, null, null)});
    private final Background REGION_BACKGROUND_DISCONNECTED = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
    private static final Function<Color, Border> REGION_BORDER = color -> new Border(new BorderStroke[]{new BorderStroke((Paint)Color.WHITE, BorderStrokeStyle.SOLID, null, new BorderWidths(2.0)), new BorderStroke((Paint)color, BorderStrokeStyle.SOLID, null, null)});
    private static final Circle REGION_SHAPE = new Circle(4.0);
    private final Region targetNode = new Region();

    public LineConnectorHandle(ConnectingFigure figure, NonNullMapAccessor<CssPoint2D> pointKey, MapAccessor<Connector> connectorKey, MapAccessor<Figure> targetKey) {
        super(figure, pointKey, connectorKey, targetKey);
        this.targetNode.setShape((Shape)REGION_SHAPE);
        this.targetNode.setMouseTransparent(true);
        this.targetNode.setManaged(false);
        this.targetNode.setScaleShape(true);
        this.targetNode.setCenterShape(true);
        this.targetNode.resize(10.0, 10.0);
    }

    public Region getNode(DrawingView view) {
        double size = view.getEditor().getHandleSize();
        if (this.targetNode.getWidth() != size) {
            this.targetNode.resize(size, size);
        }
        CssColor color = view.getEditor().getHandleColor();
        Color color1 = (Color)Paintable.getPaint(color);
        this.targetNode.setBorder(REGION_BORDER.apply(color.getColor()));
        this.REGION_BACKGROUND_CONNECTED = new Background(new BackgroundFill[]{new BackgroundFill((Paint)color1, null, null)});
        return this.targetNode;
    }

    @Override
    public void updateNode(DrawingView view) {
        ConnectingFigure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Point2D p = ((CssPoint2D)f.getNonNull(this.pointKey)).getConvertedValue();
        this.pickLocation = p = FXTransforms.transform((Transform)t, (Point2D)p);
        Connector connector = (Connector)f.get(this.connectorKey);
        Figure target = (Figure)f.get(this.targetKey);
        boolean isConnected = connector != null && target != null;
        this.targetNode.setBackground(isConnected ? this.REGION_BACKGROUND_CONNECTED : this.REGION_BACKGROUND_DISCONNECTED);
        double size = this.targetNode.getWidth();
        this.targetNode.relocate(p.getX() - size * 0.5, p.getY() - size * 0.5);
        this.targetNode.setRotate(((Double)f.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.targetNode.setRotationAxis((Point3D)f.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATION_AXIS));
        if (connector != null && target != null) {
            this.connectorLocation = view.worldToView((Point2D)connector.getPointAndDerivativeInWorld(this.owner, target).getPoint(Point2D::new));
            this.targetNode.relocate(this.connectorLocation.getX() - size * 0.5, this.connectorLocation.getY() - size * 0.5);
        } else {
            this.connectorLocation = null;
        }
    }
}

