/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.geometry.Point2D;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.draw.locator.Locator;
import org.jhotdraw8.geom.Points;

public abstract class LocatorHandle
extends AbstractHandle {
    private final Locator locator;

    public LocatorHandle(Figure owner, Locator l) {
        super(owner);
        this.locator = l;
    }

    protected Point2D getLocation() {
        return this.locator.locate(this.owner);
    }

    protected Point2D getLocation(DrawingView dv) {
        return dv.worldToView(this.owner.localToWorld(this.getLocation()));
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        Point2D p = this.getLocation(dv);
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }
}

