/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javafx.collections.ObservableSet;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.LocatorHandle;
import org.jhotdraw8.draw.locator.Locator;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

public class MoveHandle
extends LocatorHandle {
    private Point2D pickLocation;
    private CssPoint2D oldPoint;
    private final Region node = new Region();
    private static final Rectangle REGION_SHAPE = new Rectangle(5.0, 5.0);
    private static final Function<Color, Background> REGION_BACKGROUND = color -> new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, null, null)});
    private static final Function<Color, Border> REGION_BORDER = color -> new Border(new BorderStroke[]{new BorderStroke((Paint)color, BorderStrokeStyle.SOLID, null, null)});
    private Set<Figure> groupReshapeableFigures;
    private boolean pressed;

    public MoveHandle(Figure figure, Locator locator) {
        super(figure, locator);
        this.node.setShape((Shape)REGION_SHAPE);
        this.node.setManaged(false);
        this.node.setScaleShape(true);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
    }

    @Override
    public Cursor getCursor() {
        return this.pressed ? Cursor.CLOSED_HAND : Cursor.HAND;
    }

    @Override
    public Node getNode(DrawingView view) {
        double size = view.getEditor().getHandleSize();
        this.node.resize(size, size);
        CssColor color = view.getEditor().getHandleColor();
        this.node.setBorder(REGION_BORDER.apply(Color.WHITE));
        this.node.setBackground(REGION_BACKGROUND.apply(color.getColor()));
        return this.node;
    }

    @Override
    public void updateNode(DrawingView view) {
        Figure f = this.owner;
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Bounds b = f.getLayoutBounds();
        Point2D p = this.getLocation();
        this.pickLocation = p = FXTransforms.transform((Transform)t, (Point2D)p);
        double size = this.node.getWidth();
        this.node.relocate(p.getX() - size * 0.5, p.getY() - size * 0.5);
        this.node.setRotate(((Double)f.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.node.setRotationAxis((Point3D)f.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATION_AXIS));
    }

    @Override
    public void onMousePressed(MouseEvent event, DrawingView view) {
        this.pressed = true;
        this.oldPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY()))));
        ObservableSet<Figure> selectedFigures = view.getSelectedFigures();
        this.groupReshapeableFigures = new HashSet<Figure>();
        for (Figure f : view.getSelectedFigures()) {
            if (!f.isGroupReshapeableWith((Set<Figure>)selectedFigures)) continue;
            this.groupReshapeableFigures.add(f);
        }
        this.groupReshapeableFigures = view.getFiguresWithCompatibleHandle(this.groupReshapeableFigures, this);
    }

    @Override
    public void onMouseDragged(MouseEvent event, DrawingView view) {
        CssPoint2D newPoint = new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY())));
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(this.owner, newPoint);
        }
        if (event.isMetaDown()) {
            Point2D loc = this.getLocation();
            Transform localToWorld = this.owner.getLocalToWorld();
            this.oldPoint = new CssPoint2D(FXTransforms.transform((Transform)localToWorld, (Point2D)loc));
        }
        if (this.oldPoint.equals(newPoint)) {
            return;
        }
        DrawingModel model = view.getModel();
        if (event.isShiftDown()) {
            for (Figure f : this.groupReshapeableFigures) {
                this.doTranslateFigure(f, this.oldPoint, newPoint, model);
            }
        } else {
            Figure f = this.owner;
            this.doTranslateFigure(f, this.oldPoint, newPoint, model);
        }
        this.oldPoint = newPoint;
    }

    protected void doTranslateFigure(Figure f, CssPoint2D oldPoint, CssPoint2D newPoint, @Nullable DrawingModel model) {
        MoveHandle.translateFigure(f, oldPoint, newPoint, model);
    }

    public static void translateFigure(Figure f, Point2D oldPoint, Point2D newPoint, @Nullable DrawingModel model) {
        Point2D delta = newPoint.subtract(oldPoint);
        if (model != null) {
            model.translateInParent(f, new CssPoint2D(delta));
        } else {
            f.translateInParent(new CssPoint2D(delta));
        }
    }

    public static void translateFigure(Figure f, CssPoint2D oldPoint, CssPoint2D newPoint, @Nullable DrawingModel model) {
        CssPoint2D delta = newPoint.subtract(oldPoint);
        Transform wtl = f.getWorldToParent();
        CssPoint2D cssPoint2D = delta = FXTransforms.isIdentityOrNull((Transform)wtl) ? delta : new CssPoint2D(wtl.deltaTransform(delta.getConvertedValue()));
        if (model != null) {
            model.translateInParent(f, delta);
        } else {
            f.translateInParent(delta);
        }
    }

    @Override
    public void onMouseReleased(MouseEvent event, DrawingView dv) {
        this.pressed = false;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }
}

