/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;
import org.jspecify.annotations.Nullable;

public class MultipleSelectionMoveHandle
extends AbstractHandle {
    private static final @Nullable Background REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, null, null)});
    private static final @Nullable Border REGION_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.SOLID, null, null)});
    private static final Rectangle REGION_SHAPE = new Rectangle(5.0, 5.0);
    private @Nullable Point2D locationInDrawing;
    private final Region node;
    private Point2D oldPoint;
    private @Nullable Point2D pickLocation;
    private final double relativeX;
    private final double relativeY;

    public MultipleSelectionMoveHandle(double relativeX, double relativeY) {
        super(null);
        this.relativeX = relativeX;
        this.relativeY = relativeY;
        this.node = new Region();
        this.node.setShape((Shape)REGION_SHAPE);
        this.node.setManaged(false);
        this.node.setScaleShape(false);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
        this.node.setBorder(REGION_BORDER);
        this.node.setBackground(REGION_BACKGROUND);
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.OPEN_HAND;
    }

    private @Nullable Point2D getLocation(DrawingView dv) {
        return this.locationInDrawing == null ? null : dv.worldToView(this.locationInDrawing);
    }

    public @Nullable Point2D getLocationInView() {
        return this.pickLocation;
    }

    public Region getNode(DrawingView view) {
        return this.node;
    }

    @Override
    public void onMouseDragged(MouseEvent event, DrawingView view) {
        Point2D newPoint = view.viewToWorld(new Point2D(event.getX(), event.getY()));
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(this.getOwner(), new CssPoint2D(newPoint)).getConvertedValue();
        }
        if (event.isMetaDown()) {
            Point2D loc = this.getLocation(view);
            this.oldPoint = this.getOwner().localToWorld(loc);
        }
        if (this.oldPoint.equals((Object)newPoint)) {
            return;
        }
        DrawingModel model = view.getModel();
        for (Figure f : view.getSelectedFigures()) {
            Point2D npl = f.worldToParent(newPoint);
            Point2D opl = f.worldToParent(this.oldPoint);
            if (f instanceof TransformableFigure) {
                Transform tt = ((TransformableFigure)f).getInverseTransform();
                npl = FXTransforms.transform((Transform)tt, (Point2D)npl);
                opl = FXTransforms.transform((Transform)tt, (Point2D)opl);
            }
            Translate tx = Transform.translate((double)(npl.getX() - opl.getX()), (double)(npl.getY() - opl.getY()));
            model.reshapeInLocal(f, (Transform)tx);
        }
        this.oldPoint = newPoint;
    }

    @Override
    public void onMousePressed(MouseEvent event, DrawingView view) {
        this.oldPoint = view.getConstrainer().constrainPoint(this.getOwner(), new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY())))).getConvertedValue();
    }

    @Override
    public void onMouseReleased(MouseEvent event, DrawingView dv) {
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    private void updateLocation(DrawingView dv) {
        Bounds b = null;
        for (Figure f : dv.getSelectedFigures()) {
            Transform l2w = f.getLocalToWorld();
            Bounds fb = l2w.transform(f.getLayoutBounds());
            if (b == null) {
                b = fb;
                continue;
            }
            b = FXRectangles.add((Bounds)b, (Bounds)fb);
        }
        this.locationInDrawing = b == null ? null : new Point2D(b.getMinX() + this.relativeX * b.getWidth(), b.getMinY() + this.relativeY * b.getHeight());
    }

    @Override
    public void updateNode(DrawingView view) {
        Point2D p;
        this.updateLocation(view);
        this.pickLocation = p = this.getLocation(view);
        if (p != null) {
            this.node.relocate(p.getX() - 5.0, p.getY() - 5.0);
        }
    }

    public static MultipleSelectionMoveHandle northEast() {
        return new MultipleSelectionMoveHandle(1.0, 0.0);
    }

    public static MultipleSelectionMoveHandle northWest() {
        return new MultipleSelectionMoveHandle(0.0, 0.0);
    }

    public static MultipleSelectionMoveHandle southEast() {
        return new MultipleSelectionMoveHandle(1.0, 1.0);
    }

    public static MultipleSelectionMoveHandle southWest() {
        return new MultipleSelectionMoveHandle(0.0, 1.0);
    }
}

