/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.shape.Path;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.FXPathPointsBuilder;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;
import org.jspecify.annotations.Nullable;

public class PathIterablePointsHandle
extends AbstractHandle {
    private final Path node = new Path();
    private final boolean selectable;

    public PathIterablePointsHandle(PathIterableFigure figure, boolean selectable) {
        super(figure);
        this.initNode(this.node);
        this.selectable = selectable;
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        return this.node.contains(x, y);
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public Node getNode(DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.node.setStroke(Paintable.getPaint(color));
        return this.node;
    }

    protected void initNode(Path r) {
        r.setFill(null);
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public PathIterableFigure getOwner() {
        return (PathIterableFigure)super.getOwner();
    }

    @Override
    public void updateNode(DrawingView view) {
        PathIterableFigure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        ArrayList elements = new ArrayList();
        FXPathPointsBuilder builder = new FXPathPointsBuilder(view.getEditor().getHandleSize(), elements);
        AwtShapes.buildPathIterator((PathBuilder)builder, (PathIterator)f.getPathIterator(view, FXShapes.fxTransformToAwtTransform((Transform)t)));
        this.node.getElements().setAll((Collection)builder.getElements());
    }
}

