/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.function.Function;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class PolyPointEditHandle
extends AbstractHandle {
    public static final @Nullable BorderStrokeStyle INSIDE_STROKE = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 1.0, 0.0, null);
    private static final @Nullable Background REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
    private static final @Nullable Function<Color, Border> REGION_BORDER = color -> new Border(new BorderStroke[]{new BorderStroke((Paint)color, BorderStrokeStyle.SOLID, null, null)});
    private static final Rectangle REGION_SHAPE = new Rectangle(7.0, 7.0);
    private final Region node;
    private Point2D pickLocation;
    private final int pointIndex;
    private final NonNullMapAccessor<ImmutableList<Point2D>> pointKey;

    public PolyPointEditHandle(Figure figure, NonNullMapAccessor<ImmutableList<Point2D>> pointKey, int pointIndex) {
        super(figure);
        this.pointKey = pointKey;
        this.pointIndex = pointIndex;
        this.node = new Region();
        this.node.setShape((Shape)REGION_SHAPE);
        this.node.setManaged(false);
        this.node.setScaleShape(true);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
        this.node.setBackground(REGION_BACKGROUND);
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.CROSSHAIR;
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public Region getNode(DrawingView view) {
        double size = view.getEditor().getHandleSize();
        if (this.node.getWidth() != size) {
            this.node.resize(size, size);
        }
        CssColor color = view.getEditor().getHandleColor();
        this.node.setBorder(REGION_BORDER.apply(color.getColor()));
        return this.node;
    }

    @Override
    public void onMouseClicked(MouseEvent event, DrawingView dv) {
        if (this.pointKey != null && event.getClickCount() == 2 && ((ImmutableList)this.owner.get((MapAccessor)this.pointKey)).size() > 2) {
            this.removePoint(dv);
        }
    }

    private void removePoint(DrawingView dv) {
        dv.getModel().set(this.owner, this.pointKey, ((ImmutableList)this.owner.getNonNull(this.pointKey)).removeAt(this.pointIndex));
        dv.recreateHandles();
    }

    @Override
    public void onMouseDragged(MouseEvent event, DrawingView view) {
        Point2D newPoint = view.viewToWorld(new Point2D(event.getX(), event.getY()));
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(this.getOwner(), new CssPoint2D(newPoint)).getConvertedValue();
        }
        ImmutableList list = (ImmutableList)this.owner.getNonNull(this.pointKey);
        view.getModel().set(this.getOwner(), this.pointKey, list.set(this.pointIndex, (Object)this.getOwner().worldToLocal(newPoint)));
    }

    @Override
    public void onMousePressed(MouseEvent event, DrawingView dv) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, dv);
        }
    }

    protected void onPopupTriggered(MouseEvent event, DrawingView dv) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem addPoint = new MenuItem(DrawLabels.getResources().getString("handle.removePoint.text"));
        addPoint.setOnAction(actionEvent -> this.removePoint(dv));
        contextMenu.getItems().add((Object)addPoint);
        contextMenu.show((Node)this.node, event.getScreenX(), event.getScreenY());
        event.consume();
    }

    @Override
    public void onMouseReleased(MouseEvent event, DrawingView dv) {
        if (event.isPopupTrigger()) {
            this.onPopupTriggered(event, dv);
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void updateNode(DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        ImmutableList list = (ImmutableList)f.get((MapAccessor)this.pointKey);
        if (list == null || this.pointIndex > list.size()) {
            this.node.setVisible(false);
            return;
        }
        this.node.setVisible(true);
        Point2D p = (Point2D)list.get(this.pointIndex);
        this.pickLocation = p = FXTransforms.transform((Transform)t, (Point2D)p);
        double size = this.node.getWidth();
        this.node.relocate(p.getX() - size * 0.5, p.getY() - size * 0.5);
        this.node.setRotate(((Double)f.getStyled((MapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.node.setRotationAxis((Point3D)f.getStyled((MapAccessor)TransformableFigure.ROTATION_AXIS));
    }
}

