/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.awt.geom.PathIterator;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.PolylineFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.FXGeom;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.intersect.IntersectCircleLine;
import org.jhotdraw8.geom.intersect.IntersectPathIteratorPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class PolygonOutlineHandle
extends AbstractHandle {
    private final boolean editable;
    private final NonNullMapAccessor<ImmutableList<Point2D>> key;
    private final Group node;
    private final Polygon poly1;
    private final Polygon poly2;

    public PolygonOutlineHandle(Figure figure, NonNullMapAccessor<ImmutableList<Point2D>> key) {
        this(figure, key, true);
    }

    public PolygonOutlineHandle(Figure figure, NonNullMapAccessor<ImmutableList<Point2D>> key, boolean editable) {
        super(figure);
        this.key = key;
        this.editable = editable;
        this.node = new Group();
        this.poly1 = new Polygon();
        this.poly2 = new Polygon();
        this.poly1.setFill(null);
        this.poly2.setFill(null);
        this.node.getChildren().addAll((Object[])new Node[]{this.poly1, this.poly2});
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        if (FXRectangles.contains((Bounds)this.poly2.getBoundsInParent(), (double)x, (double)y, (double)tolerance)) {
            IntersectionResult i = IntersectPathIteratorPoint.intersectPathIteratorPoint((PathIterator)AwtShapes.pointCoordsToPathIterator((List)this.poly2.getPoints(), (boolean)true, (int)0, null), (double)x, (double)y, (double)tolerance);
            return i.getStatus() == IntersectionStatus.INTERSECTION;
        }
        return false;
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public Node getNode(DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.poly1.setStroke((Paint)Color.WHITE);
        this.poly2.setStroke(Paintable.getPaint(color));
        double strokeWidth = view.getEditor().getHandleStrokeWidth();
        this.poly1.setStrokeWidth(strokeWidth + 2.0);
        this.poly2.setStrokeWidth(strokeWidth);
        return this.node;
    }

    @Override
    public void onMousePressed(MouseEvent event, DrawingView dv) {
        if (this.editable && event.isPopupTrigger()) {
            this.onPopupTriggered(event, dv);
        }
    }

    @Override
    public void onMouseReleased(MouseEvent event, DrawingView dv) {
        if (this.editable && event.isPopupTrigger()) {
            this.onPopupTriggered(event, dv);
        }
    }

    protected void onPopupTriggered(MouseEvent event, DrawingView dv) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem addPoint = new MenuItem(DrawLabels.getResources().getString("handle.addPoint.text"));
        addPoint.setOnAction(actionEvent -> this.addPoint(event, dv));
        contextMenu.getItems().add((Object)addPoint);
        contextMenu.show((Node)this.node, event.getScreenX(), event.getScreenY());
        event.consume();
    }

    @Override
    public void onMouseClicked(MouseEvent event, DrawingView dv) {
        if (this.editable && this.key != null && event.getClickCount() == 2) {
            this.addPoint(event, dv);
        }
    }

    private void addPoint(MouseEvent event, DrawingView view) {
        ImmutableList points = (ImmutableList)this.owner.get((MapAccessor)this.key);
        Point2D pInDrawing = view.viewToWorld(new Point2D(event.getX(), event.getY()));
        Point2D pInLocal = this.owner.worldToLocal(pInDrawing);
        double tolerance = view.getViewToWorld().deltaTransform(view.getEditor().getTolerance(), 0.0).getX();
        double px = pInLocal.getX();
        double py = pInLocal.getY();
        int insertAt = -1;
        Point2D insertLocation = null;
        int n = points.size();
        for (int i = 0; i < n; ++i) {
            Point2D p1 = (Point2D)points.get((n + i - 1) % n);
            Point2D p2 = (Point2D)points.get(i);
            IntersectionResultEx result = IntersectCircleLine.intersectLineCircleEx((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY(), (double)px, (double)py, (double)tolerance);
            if (result.getAllArgumentsA().size() != 2) continue;
            insertLocation = FXGeom.lerp((Point2D)p1, (Point2D)p2, (double)((((IntersectionPointEx)result.intersections().getFirst()).argumentA() + ((IntersectionPointEx)result.intersections().getLast()).argumentA()) / 2.0));
            insertAt = i;
            break;
        }
        if (insertAt != -1) {
            view.getModel().set(this.owner, this.key, ((ImmutableList)this.owner.getNonNull(this.key)).add(insertAt, insertLocation));
            view.recreateHandles();
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void updateNode(DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Bounds b = this.getOwner().getLayoutBounds();
        double[] points = PolylineFigure.toPointArray(f, this.key);
        FXTransforms.transform2DPoints((Transform)t, (double[])points, (int)0, (double[])points, (int)0, (int)(points.length / 2));
        ObservableList pp1 = this.poly1.getPoints();
        ObservableList pp2 = this.poly2.getPoints();
        pp2.clear();
        pp1.clear();
        for (double point : points) {
            pp1.add((Object)point);
            pp2.add((Object)point);
        }
    }
}

